package math;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class RollingSum extends Statistic{
	
	Double sum = 0d;
	Queue<Double> queue;
	AccumulatedSum initialSum;
	
	public RollingSum(int sampleSize) {
		this.sampleSize = sampleSize;
		queue = new ArrayBlockingQueue<Double>(sampleSize); 
		initialSum = new AccumulatedSum();
	}
	
	public double calculate(double n) {
		if (queueIsFull())
			fullQueueCalculate(n);
		else
			partialQueueCalculate(n);
		
		queue.offer(n);
		
		return queueIsFull() ? sum : Double.NaN;
	}

	private boolean queueIsFull() {
		return queue.size() == sampleSize;
	}	
	
	private void fullQueueCalculate(double n){
		sum = sum - queue.poll() + n;
	}
	
	private void partialQueueCalculate(double n){
		sum = initialSum.calculate(n);
	}
}