/*
 *   @(#) $Id$
 *
 *   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

package org.apache.mina.examples.bug;

import java.io.Serializable;
import java.util.Arrays;

/**
 * This class describe a "message" that can be used for communication. It is
 * only intended to show that you can use custom classes that will be serialized
 * and sent over the net (using the protocol you choose), and deserialized by
 * the receiving entity.
 * <p>
 * As usual with Java serialization, your custom message classes must implements
 * the {@link Serializable} interface. 
 * 
 * @author Matteo Merli (matteo.merli@gmail.com)
 * @version $Rev$
 */
public class Message implements Serializable
{

	private byte[] content;
	private String description;
	private int type;
	
	public Message( int type, String description, byte[] content )
	{
		this.type = type;
		this.description = description;
		this.content = content;
	}

	public byte[] getContent()
	{
		return content;
	}

	public String getDescription()
	{
		return description;
	}

	public int getType()
	{
		return type;
	}

	public void setContent( byte[] content )
	{
		this.content = content;
	}

	
	public void setDescription( String description )
	{
		this.description = description;
	}

	
	public void setType( int type )
	{
		this.type = type;
	}

	
	public String toString()
	{
		return "{Message: type=" + type + ", description='" + description + "',"
				+ " content=" + content.length + "}";
	}

}
