/*
 *   @(#) $Id$
 *
 *   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

package org.apache.mina.examples.bug;

import java.util.logging.Logger;

import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TransportType;
import org.apache.mina.filter.SerializationFilter;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;
import org.apache.mina.registry.SimpleServiceRegistry;

/**
 * Test server implementation using the serialization filter.
 * 
 * @author Matteo Merli (matteo.merli@gmail.com)
 * @version $Rev$
 */
public class Server extends IoHandlerAdapter
{

	private static final Logger log = Logger.getLogger( Server.class.getName() );

	/** Choose your favorite port number. */
	public static final int PORT = 8080;

	private static SerializationFilter serializationFilter = new SerializationFilter();

	public static void main( String[] args ) throws Exception
	{
		ServiceRegistry registry = new SimpleServiceRegistry();

		// Bind
		Service service = new Service( "test_serial", TransportType.SOCKET, PORT );
		registry.bind( service, new Server() );

		log.info( "Listening on port " + PORT );
	}

	public void sessionCreated( IoSession session ) throws Exception
	{
		// Add the serialization filter
		session.getFilterChain().addLast( "serialization", serializationFilter );
		log.info( "Connection from client: " + session.getRemoteAddress() );
	}

	public void messageReceived( IoSession session, Object object ) throws Exception
	{
		Message message = (Message) object;
		log.info( "Received from client: " + message );

		// Reply with another message
		Message response = new Message( 2, "Server->Client", 
				new byte[] { 5, 4, 3, 2, 1 } );

		session.write( response );
	}
}
