/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ScpWagon
extends AbstractSshWagon {
    private static final char PATH_SEPARATOR = '/';
    private static final char COPY_START_CHAR = 'C';
    private static final char ACK_SEPARATOR = ' ';
    private static final String END_OF_FILES_MSG = "E\n";

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        String dir = PathUtils.dirname((String)resourceName);
        dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        try {
            String dirPerms;
            String umaskCmd = null;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
            }
            String mkdirCmd = "mkdir -p " + ScpWagon.getPath((String)basedir, (String)dir);
            if (umaskCmd != null) {
                mkdirCmd = String.valueOf(umaskCmd) + "; " + mkdirCmd;
            }
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
        ChannelExec channel = null;
        OutputStream out = null;
        String path = ScpWagon.getPath((String)basedir, (String)resourceName);
        RepositoryPermissions permissions = this.getRepository().getPermissions();
        try {
            try {
                String command = "scp -t " + path;
                this.fireTransferDebug("Executing command: " + command);
                channel = (ChannelExec)this.session.openChannel("exec");
                channel.setCommand(command);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                this.checkAck(in);
                long filesize = source.length();
                String mode = "644";
                if (permissions != null && permissions.getFileMode() != null) {
                    if (permissions.getFileMode().matches("[0-9]{3}")) {
                        mode = permissions.getFileMode();
                    } else {
                        this.fireSessionDebug("Not using non-octal permissions: " + mode);
                    }
                }
                command = "C0" + mode + " " + filesize + " ";
                command = resourceName.lastIndexOf(47) > 0 ? String.valueOf(command) + resourceName.substring(resourceName.lastIndexOf(47) + 1) : String.valueOf(command) + resourceName;
                command = String.valueOf(command) + "\n";
                out.write(command.getBytes());
                out.flush();
                this.checkAck(in);
                this.putTransfer(resource, source, out, false);
                ScpWagon.sendEom(out);
                this.checkAck(in);
                out.write(END_OF_FILES_MSG.getBytes());
                out.flush();
            }
            catch (IOException e) {
                String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                throw new TransferFailedException(msg, (Throwable)e);
            }
            catch (JSchException e) {
                String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                throw new TransferFailedException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (channel != null) {
                IOUtil.close(out);
                channel.disconnect();
            }
            throw throwable;
        }
        if (channel != null) {
            IOUtil.close((OutputStream)out);
            channel.disconnect();
        }
        try {
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                if (permissions.getFileMode().matches("[0-9]{3}")) {
                    this.executeCommand("chmod -f " + permissions.getFileMode() + " " + path);
                } else {
                    this.fireSessionDebug("Not using non-octal permissions: " + permissions.getFileMode());
                }
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
    }

    private void checkAck(InputStream in) throws IOException, TransferFailedException {
        int code = in.read();
        if (code == -1) {
            throw new TransferFailedException("Unexpected end of data");
        }
        if (code == 1) {
            String line = this.readLine(in);
            throw new TransferFailedException("SCP terminated with error: '" + line + "'");
        }
        if (code == 2) {
            throw new TransferFailedException("SCP terminated with error (code: " + code + ")");
        }
        if (code != 0) {
            throw new TransferFailedException("SCP terminated with unknown error code");
        }
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        ChannelExec channel = null;
        OutputStream out = null;
        String basedir = this.getRepository().getBasedir();
        try {
            try {
                String path = ScpWagon.getPath((String)basedir, (String)resourceName);
                String cmd = "scp -f " + path;
                this.fireTransferDebug("Executing command: " + cmd);
                channel = (ChannelExec)this.session.openChannel("exec");
                channel.setCommand(cmd);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                ScpWagon.sendEom(out);
                int exitCode = in.read();
                if (exitCode == 80) {
                    exitCode = in.read();
                }
                String line = this.readLine(in);
                if (exitCode != 67) {
                    if (exitCode == 1 && line.endsWith("No such file or directory")) {
                        throw new ResourceDoesNotExistException(line);
                    }
                    throw new TransferFailedException("Exit code: " + exitCode + " - " + line);
                }
                if (line == null) {
                    throw new EOFException("Unexpected end of data");
                }
                String perms = line.substring(0, 4);
                this.fireTransferDebug("Remote file permissions: " + perms);
                if (line.charAt(4) != ' ' && line.charAt(5) != ' ') {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int index = line.indexOf(32, 5);
                if (index < 0) {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int filesize = Integer.valueOf(line.substring(5, index));
                this.fireTransferDebug("Remote file size: " + filesize);
                resource.setContentLength((long)filesize);
                String filename = line.substring(index + 1);
                this.fireTransferDebug("Remote filename: " + filename);
                ScpWagon.sendEom(out);
                this.getTransfer(resource, destination, in, false, filesize);
                if (destination.length() != (long)filesize) {
                    throw new TransferFailedException("Expected file length: " + filesize + "; received = " + destination.length());
                }
                this.checkAck(in);
                ScpWagon.sendEom(out);
            }
            catch (JSchException e) {
                this.handleGetException(resource, (Exception)((Object)e), destination);
            }
            catch (IOException e) {
                this.handleGetException(resource, e, destination);
            }
        }
        finally {
            IOUtil.close(out);
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("getIfNewer is scp wagon must be still implemented");
    }
}

