/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.knownhost;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.wagon.providers.ssh.knownhost.StreamKnownHostsProvider;
import org.codehaus.plexus.util.IOUtil;

public class FileKnownHostsProvider
extends StreamKnownHostsProvider {
    private final File file;

    public FileKnownHostsProvider(File file) throws IOException {
        super(file.exists() ? new FileInputStream(file) : new ByteArrayInputStream("".getBytes()));
        this.file = file;
    }

    public FileKnownHostsProvider() throws IOException {
        this(new File(System.getProperty("user.home"), ".ssh/known_hosts"));
    }

    public void storeKnownHosts(JSch sch) {
        PrintWriter w = null;
        try {
            try {
                w = new PrintWriter(new FileWriter(this.file));
                HostKeyRepository hkr = sch.getHostKeyRepository();
                HostKey[] keys = hkr.getHostKey();
                int i = 0;
                while (i < keys.length) {
                    HostKey key = keys[i];
                    w.println(String.valueOf(key.getHost()) + " " + key.getType() + " " + key.getKey());
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            IOUtil.close(w);
        }
        super.storeKnownHosts(sch);
    }

    public File getFile() {
        return this.file;
    }
}

