package org.foo.internal;

import java.util.Dictionary;
import java.util.Properties;

import org.foo.ExampleService1;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;


/**
 * Extension of the default OSGi bundle activator
 */
public final class ExampleActivator1
    implements BundleActivator
{
    /**
     * Called whenever the OSGi framework starts our bundle
     */
    public void start( BundleContext bc )
        throws Exception
    {
        System.out.println( "STARTING org.foo.osgi" );

        Dictionary props = new Properties();
        // add specific service properties here...

        System.out.println( "REGISTER org.foo.osgi.ExampleService1" );

        // Register our example service implementation in the OSGi service registry
        bc.registerService( ExampleService1.class.getName(), new ExampleService1Impl(), props );
    }

    /**
     * Called whenever the OSGi framework stops our bundle
     */
    public void stop( BundleContext bc )
        throws Exception
    {
        System.out.println( "STOPPING org.foo.osgi" );

        // no need to unregister our service - the OSGi framework handles it for us
    }
}

