package org.foo.internal;

import java.util.Dictionary;
import java.util.Properties;

import org.foo.ExampleService2;
import org.foo.Sample;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;


/**
 * Extension of the default OSGi bundle activator
 */
public final class ExampleActivator2
    implements BundleActivator
{
    /**
     * Called whenever the OSGi framework starts our bundle
     */
    public void start( BundleContext bc )
        throws Exception
    {
        System.out.println( "STARTING org.foo.osgi" );

        Dictionary props = new Properties();
        // add specific service properties here...

        System.out.println( "Tralala");
        System.out.println( new Sample().getString());
        System.out.println( "REGISTER org.foo.osgi.ExampleService2" );

        // Register our example service implementation in the OSGi service registry
        bc.registerService( ExampleService2.class.getName(), new ExampleService2Impl(), props );
    }

    /**
     * Called whenever the OSGi framework stops our bundle
     */
    public void stop( BundleContext bc )
        throws Exception
    {
        System.out.println( "STOPPING org.foo.osgi" );

        // no need to unregister our service - the OSGi framework handles it for us
    }
}

