package data;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ADR")
public class Address {

	private String HOME, WORK, POSTAL, PARCEL, DOM, INTL, PREF;
	
	private String POBOX;
	private String EXTADD;
	private String STREET;
	private String LOCALITY;
	private String REGION;
	private String PCODE;
	private String CTRY;

	public Address() { 
	}
	
	public Address(String TYP) { 
		setTYPE(TYP);
	}
	
	public Address(String TYP, Map<String,String> parameters) { 
		setTYPE(TYP);
		setParameters(parameters);
	}
	
	
	@XmlElement(name="EXTADD")
	public String getEXTADD() {
		return EXTADD;
	}

	@XmlElement(name="STREET")
	public String getSTREET() {
		return STREET;
	}
	
	@XmlElement(name="LOCALITY")
	public String getLOCALITY() {
		return LOCALITY;
	}

	@XmlElement(name="REGION")
	public String getREGION() {
		return REGION;
	}
	
	@XmlElement(name="PCODE")
	public String getPCODE() {
		return PCODE;
	}

	@XmlElement(name="CTRY")
	public String getCTRY() {
		return CTRY;
	}

	@XmlElement(name="POBOX")
	public String getPOBOX() {
		return POBOX;
	}

	
	public void setTYPE(String TYP) {
		if (TYP.equals("HOME")) {
			setHOME("");
		} else if (TYP.equals("WORK")) {
			setWORK("");
		} else if (TYP.equals("POSTAL")) {
			setPOSTAL("");
		} else if (TYP.equals("PARCEL")) {
			setPARCEL("");
		} else if (TYP.equals("DOM")) {
			setDOM("");
		} else if (TYP.equals("INTL")) {
			setINTL("");
		} else if (TYP.equals("PREF")) {
			setPREF("");
		} else {
			// do nothing
		}
	}
	
	public void setPOBOX(String pOBOX) {
		POBOX = pOBOX;
	}

	public void setEXTADD(String eXTADD) {
		EXTADD = eXTADD;
	}

	public void setSTREET(String sTREET) {
		STREET = sTREET;
	}

	public void setLOCALITY(String lOCALITY) {
		LOCALITY = lOCALITY;
	}

	public void setREGION(String rEGION) {
		REGION = rEGION;
	}

	public void setPCODE(String pCODE) {
		PCODE = pCODE;
	}

	public void setCTRY(String cTRY) {
		CTRY = cTRY;
	}

	public void setParameters(Map<String,String> parameters) {
		Iterator<Entry<String, String>> it = parameters.entrySet().iterator();
	    while (it.hasNext()) {
	    	Entry<String, String> element = (Entry<String, String>)it.next();
	        if (element.getKey().equals("POBOX")) {
	        	this.setPOBOX(element.getValue());
	        } else if (element.getKey().equals("EXTADD")) {
	        	this.setEXTADD(element.getValue());
	        } else if (element.getKey().equals("STREET")) {
	        	this.setSTREET(element.getValue());
	        } else if (element.getKey().equals("LOCALITY")) {
	        	this.setLOCALITY(element.getValue());
	        } else if (element.getKey().equals("REGION")) {
	        	this.setREGION(element.getValue());
	        } else if (element.getKey().equals("PCODE")) {
	        	this.setPCODE(element.getValue());
	        } else if (element.getKey().equals("CTRY")) {
	        	this.setCTRY(element.getValue());
	        } else {
	        	setTYPE(element.getValue());
	        }
	    }
	}

	
	@XmlElement(name="HOME")
	public String getHOME() {
		return HOME;
	}

	@XmlElement(name="WORK")
	public String getWORK() {
		return WORK;
	}

	@XmlElement(name="POSTAL")
	public String getPOSTAL() {
		return POSTAL;
	}

	@XmlElement(name="PARCEL")
	public String getPARCEL() {
		return PARCEL;
	}

	@XmlElement(name="DOM")
	public String getDOM() {
		return DOM;
	}
		
	@XmlElement(name="INTL")
	public String getINTL() {
		return INTL;
	}

	@XmlElement(name="PREF")
	public String getPREF() {
		return PREF;
	}

	
	
	
	public void setHOME(String HOME) {
		this.HOME = HOME;
	}

	public void setWORK(String WORK) {
		this.WORK = WORK;
	}

	public void setPOSTAL(String POSTAL) {
		this.POSTAL = POSTAL;
	}

	public void setPARCEL(String PARCEL) {
		this.PARCEL = PARCEL;
	}

	public void setDOM(String DOM) {
		this.DOM = DOM;
	}

	public void setINTL(String INTL) {
		this.INTL = INTL;
	}

	public void setPREF(String PREF) {
		this.PREF = PREF;
	}
	
	// -------------------------
	
	
	public boolean contains(String search_expression) {
		boolean match = false;	
		if (search_expression!=null) {
			if (	((this.getPOBOX()!=null)&&(this.getPOBOX().contains(search_expression))) 
					|| ((this.getEXTADD()!=null)&&(this.getEXTADD().contains(search_expression)))
					|| ((this.getSTREET()!=null)&&(this.getSTREET().contains(search_expression)))
					|| ((this.getLOCALITY()!=null)&&(this.getLOCALITY().contains(search_expression)))
					|| ((this.getREGION()!=null)&&(this.getREGION().contains(search_expression)))
					|| ((this.getPCODE()!=null)&&(this.getPCODE().contains(search_expression)))
					|| ((this.getCTRY()!=null)&&(this.getCTRY().contains(search_expression)))
				) {
				match = true;
			}
		}
		return match;
	}
	
	public String toHTML() {
			
		String suffix = "<i>(";
		if (this.getHOME()!=null) 	{ suffix = suffix + ", HOME"; 	}
		if (this.getWORK()!=null) 	{ suffix = suffix + ", WORK";	}
		if (this.getPOSTAL()!=null) { suffix = suffix + ", POSTAL";	}
		if (this.getPARCEL()!=null) { suffix = suffix + ", PARCEL";	}
		if (this.getDOM()!=null) 	{ suffix = suffix + ", DOM";	}
		if (this.getINTL()!=null) 	{ suffix = suffix + ", INTL";	}
		if (this.getPREF()!=null) 	{ suffix = suffix + ", PREF";	}
		suffix = suffix.replaceFirst(", ", "") + ")</i>";
		
		String r = "";
		if (this.getPOBOX()!=null) {
			r+="<b>POBOX:</b> "+this.getPOBOX()+"<br>";
		}
		if (this.getEXTADD()!=null) {
			r+="<b>EXTADD:</b> "+this.getEXTADD()+"<br>";
		}
		if (this.getSTREET()!=null) {
			r+="<b>STREET:</b> "+this.getSTREET()+"<br>";
		}
		if (this.getPCODE()!=null) {
			r+="<b>PCODE:</b> "+this.getPCODE()+"<br>";
		}
		if (this.getLOCALITY()!=null) {
			r+="<b>LOCALITY:</b> "+this.getLOCALITY()+"<br>";
		}
		if (this.getREGION()!=null) {
			r+="<b>REGION:</b> "+this.getREGION()+"<br>";
		}
		if (this.getCTRY()!=null) {
			r+="<b>CTRY:</b> "+this.getCTRY()+"<br>";
		}
		
		return r+suffix;
	}

}
