package test;

import data.Address;
import org.junit.Test;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import java.io.IOException;

public class AddressTest extends JAXBTest {

    @Test
    public void testSerialization() throws IOException, JAXBException {

        Address address = new Address();
        address.setCTRY("Germany");
        address.setLOCALITY("Lübeck");
        address.setPOSTAL("23552");

        JAXBContext context = JAXBContext.newInstance(Address.class);

        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

        marshaller.marshal(address, System.out);

    }


}
