package test;

import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;

import static org.ops4j.pax.exam.CoreOptions.*;
import static org.ops4j.pax.exam.CoreOptions.mavenBundle;
import static org.ops4j.pax.exam.CoreOptions.provision;


@RunWith(JUnit4TestRunner.class)
public abstract class JAXBTest {

    @Configuration
    public static Option[] configuration() {
        return options(
                frameworks(
                        equinox(),
                        felix()
                ),
                provision(
                        mavenBundle().groupId("org.osgi").artifactId("org.osgi.core").version("4.2.0").startLevel(1),
                        mavenBundle().groupId("org.osgi").artifactId("org.osgi.compendium").version("4.2.0").startLevel(1),
                        mavenBundle().groupId("org.apache.cxf.dosgi").artifactId("cxf-dosgi-ri-singlebundle-distribution")
                                .version("1.1").start(true).startLevel(1),
                        mavenBundle().groupId("de.uniluebeck.itm").artifactId("jaxb-cxf-issue-project.data")
                                .version("0.1-SNAPSHOT").startLevel(2)
                )
        );
    }

}
