/**
 * Wrapper class for the class unloading unit test
 */
public class Runme {
  private static void printUsage() {
    System.err.println("Usage: java Runme [-db location] [-tps n] [-total_trans n] [-clients n]");
  }

  private static void printUsageAndDie(String whatHappened) {
    System.err.println("Syntax error: "+whatHappened);
    System.err.println();
    printUsage();
    System.exit(1);
  }

  public static void main(String[] args) {
    String dbLocation = "test-db";
    Integer clients = 1, total_trans = 4000, tps = 32;
    for (int i=0; i < args.length; i++) {
      if (args[i].charAt(0) == '-') {
        if (args[i].equals("-db")) {
          i++;
          if (i >= args.length) {
            printUsageAndDie("The \"-db\" flag must have an argument");
          }
          dbLocation = args[i];
        } else if (args[i].equals("-clients")) {
          i++;
          if (i >= args.length) {
            printUsageAndDie("The \"-clients\" flag must have an argument");
          }
          clients = Integer.parseInt(args[i]);
        } else if (args[i].equals("-total_trans")) {
          i++;
          if (i >= args.length) {
            printUsageAndDie("The \"-total_trans\" flag must have an argument");
          }
          total_trans = Integer.parseInt(args[i]);
        } else if (args[i].equals("-tps")) {
          i++;
          if (i >= args.length) {
            printUsageAndDie("The \"-tps\" flag must have an argument");
          }
          tps = Integer.parseInt(args[i]);
        } else if (args[i].equals("-h") || args[i].equals("-?")) {
          printUsage();
          System.exit(0);
        } else {
          printUsageAndDie("Unrecognized switch, \""+args[i]+"\"");
        }
      } else {
        printUsageAndDie("Unrecognized parameter, \""+args[i]+"\"");
      }
    }

    /* Do it */
    dacapo.PseudoJDBCBench.main(new String[] {
      "-driver","org.apache.derby.jdbc.EmbeddedDriver",
      "-url","jdbc:derby:"+dbLocation+";create=true",
      "-init",
      "-user","sa","-clients",clients.toString(),
      "-total_trans",total_trans.toString(),
      "-tps",tps.toString() });
  }
}