/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * @author Roman S. Bushmanov
 * @version $Revision: 1.1.2.1.4.3 $
 */

 package java.lang;

/**
 * @com.intel.drl.spec_ref
 *
 */
public class Object {
    
    private static native void mynativemethod(int a, int b);

    private static native void mynativedumpint(int a, int b);

    private static native void mynativedumplong(int a, long b);

    private static native void mynativedumpdouble(int a, double b);

    private static native void mynativedumpbool(int a, boolean b);

    int passthrough(int val) {
        return val;
    }

    void test1() {
        int val1;
        int val2;

        val1 = 27;
        val2 = passthrough(32);
        mynativemethod(val1, val2);
        mynativemethod(16, 99);
    }

    int add32(int a, int b) {
        return a + b;
    }

    void test2() {
        int val1;
        int val2;

        val1 = add32(900, 1000);
        val2 = add32(-5, 200);
        mynativedumpint(2, val1);
        mynativedumpint(2, val2);
    }

    void test3() {
        mynativedumplong(3, 932);
    }

    void test4() {
        mynativedumpdouble(4, 3.14159);
    }

    long add64(long a, long b) {
        return a + b;
    }
    
    void test5() {
        long val1;
        long val2;

        val1 = add64(900, 1000);
        val2 = add64(-5, 200);
        mynativedumplong(5, val1);
        mynativedumplong(5, val2);
    }

    double addf64(double a, double b) {
        return a + b;
    }

    void test6() {
        double val1;
        double val2;

        val1 = addf64(3.14159, 2.71828183);
        val2 = addf64(1.5, 0.25);
        mynativedumpdouble(6, val1);
        mynativedumpdouble(6, val2);
    }

    short add16(short a, short b) {
        return (short)(a + b);
    }

    void test7() {
        short val1;
        short val2;

        val1 = add16((short)900, (short)1000);
        val2 = add16((short)-5, (short)200);
        mynativedumpint(7, (int)val1);
        mynativedumpint(7, (int)val2);
    }

    byte add8(byte a, byte b) {
        return (byte)(a + b);
    }

    void test8() {
        byte val1;
        byte val2;

        val1 = add8((byte)10, (byte)20);
        val2 = add8((byte)-5, (byte)18);
        mynativedumpint(8, (int)val1);
        mynativedumpint(8, (int)val2);
    }


    int sub32(int a, int b) {
        return a - b;
    }

    void test9() {
        int val1;
        int val2;

        val1 = sub32(900, 1000);
        val2 = sub32(-5, 200);
        mynativedumpint(9, val1);
        mynativedumpint(9, val2);
    }

    long sub64(long a, long b) {
        return a - b;
    }
    
    void test10() {
        long val1;
        long val2;

        val1 = sub64(900, 1000);
        val2 = sub64(-5, 200);
        mynativedumplong(10, val1);
        mynativedumplong(10, val2);
    }

    double subf64(double a, double b) {
        return a - b;
    }

    void test11() {
        double val1;
        double val2;

        val1 = subf64(3.14159, 2.71828183);
        val2 = subf64(1.5, 0.25);
        mynativedumpdouble(11, val1);
        mynativedumpdouble(11, val2);
    }


    int mult32(int a, int b) {
        return a * b;
    }

    void test12() {
        int val1;
        int val2;

        val1 = mult32(900, 1000);
        val2 = mult32(-5, 200);
        mynativedumpint(12, val1);
        mynativedumpint(12, val2);
    }

    long mult64(long a, long b) {
        return a * b;
    }
    
    void test13() {
        long val1;
        long val2;

        val1 = mult64(900, 1000);
        val2 = mult64(-5, 200);
        mynativedumplong(13, val1);
        mynativedumplong(13, val2);
    }

    double multf64(double a, double b) {
        return a * b;
    }

    void test14() {
        double val1;
        double val2;

        val1 = multf64(3.14159, 2.71828183);
        val2 = multf64(1.5, 0.25);
        mynativedumpdouble(14, val1);
        mynativedumpdouble(14, val2);
    }

    int div32(int a, int b) {
        return a / b;
    }

    void test15() {
        int val1;
        int val2;

        val1 = div32(25000, 33);
        val2 = div32(-5344327, 7);
        mynativedumpint(15, val1);
        mynativedumpint(15, val2);
    }

    long div64(long a, long b) {
        return a / b;
    }
    
    void test16() {
        long val1;
        long val2;

        val1 = div64(25000, 33);
        val2 = div64(-5344327, 7);
        mynativedumplong(16, val1);
        mynativedumplong(16, val2);
    }

    double divf64(double a, double b) {
        return a / b;
    }

    void test17() {
        double val1;
        double val2;

        val1 = divf64(3.14159, 2.71828183);
        val2 = divf64(1.5, 0.25);
        mynativedumpdouble(17, val1);
        mynativedumpdouble(17, val2);
    }


    int lshift32(int a, int b) {
        return a << b;
    }

    int rshift32(int a, int b) {
        return a >> b;
    }

    int lshift32i(int a) {
        return a << 7;
    }

    int rshift32i(int a) {
        return a >> 10;
    }

    void test18() {
        int val1;
        int val2;

        val1 = lshift32(900, 4);
        val2 = rshift32(-5, 1);
        mynativedumpint(18, val1);
        mynativedumpint(18, val2);

        val1 = lshift32i(5);
        val2 = rshift32i(1405955457);
        mynativedumpint(18, val1);
        mynativedumpint(18, val2);
    }

    long lshift64(long a, int b) {
        return a << b;
    }

    long rshift64(long a, int b) {
        return a >> b;
    }

    long lshift64i(long a) {
        return a << 35;
    }

    long rshift64i(long a) {
        return a >> 40;
    }
    
    void test19() {
        long val1;
        long val2;

        val1 = lshift64(6038532708793880769L, 18);
        val2 = rshift64(6038532708793880769L, 45);
        mynativedumplong(19, val1);
        mynativedumplong(19, val2);

        val1 = lshift64i(5);
        val2 = rshift64i(6038532708793880769L);
        mynativedumplong(19, val1);
        mynativedumplong(19, val2);
    }

    int and32(int a, int b) {
        return a & b;
    }

    void test20() {
        int val1;
        int val2;

        val1 = and32(0x00ffff00, 0xffff0000);
        val2 = and32(0xaaaaaaaa, 0xdeadbeef);
        mynativedumpint(20, val1);
        mynativedumpint(20, val2);
    }
    
    long and64(long a, long b) {
        return a & b;
    }

    void test21() {
        long val1;
        long val2;

        val1 = and64(0x0000ffffffff0000L, 0xffffffff00000000L);
        val2 = and64(0xaaaaaaaaaaaaaaaaL, 0xdeadbeefdeadbeefL);
        mynativedumplong(21, val1);
        mynativedumplong(21, val2);
    }

    int or32(int a, int b) {
        return a | b;
    }

    void test22() {
        int val1;
        int val2;

        val1 = or32(0x00ffff00, 0xffff0000);
        val2 = or32(0xaaaaaaaa, 0xdeadbeef);
        mynativedumpint(22, val1);
        mynativedumpint(22, val2);
    }
    
    long or64(long a, long b) {
        return a | b;
    }

    void test23() {
        long val1;
        long val2;

        val1 = or64(0x0000ffffffff0000L, 0xffffffff00000000L);
        val2 = or64(0xaaaaaaaaaaaaaaaaL, 0xdeadbeefdeadbeefL);
        mynativedumplong(23, val1);
        mynativedumplong(23, val2);
    }

    int xor32(int a, int b) {
        return a ^ b;
    }

    void test24() {
        int val1;
        int val2;

        val1 = xor32(0x00ffff00, 0xffff0000);
        val2 = xor32(0xaaaaaaaa, 0xdeadbeef);
        mynativedumpint(24, val1);
        mynativedumpint(24, val2);
    }

    long xor64(long a, long b) {
        return a ^ b;
    }

    void test25() {
        long val1;
        long val2;

        val1 = xor64(0x0000ffffffff0000L, 0xffffffff00000000L);
        val2 = xor64(0xaaaaaaaaaaaaaaaaL, 0xdeadbeefdeadbeefL);
        mynativedumplong(25, val1);
        mynativedumplong(25, val2);
    }

    int not32(int a) {
        return ~a;
    }

    void test26() {
        int val1;
        int val2;

        val1 = not32(0x00ffff00);
        val2 = not32(0xaaaaaaaa);
        mynativedumpint(26, val1);
        mynativedumpint(26, val2);
    }

    long not64(long a) {
        return ~a;
    }

    void test27() {
        long val1;
        long val2;

        val1 = not64(0x0000ffffffff0000L);
        val2 = not64(0xaaaaaaaaaaaaaaaaL);
        mynativedumplong(27, val1);
        mynativedumplong(27, val2);
    }

    boolean booland(boolean a, boolean b) {
        return a && b;
    }

    void test28() {
        boolean val1;
        boolean val2;

        val1 = booland(true, false);
        val2 = booland(true, true);
        mynativedumpbool(28, val1);
        mynativedumpbool(28, val2);
    }

    boolean boolor(boolean a, boolean b) {
        return a || b;
    }

    void test29() {
        boolean val1;
        boolean val2;

        val1 = boolor(true, false);
        val2 = boolor(false, false);
        mynativedumpbool(29, val1);
        mynativedumpbool(29, val2);
    }

    boolean boolnot(boolean a) {
        return !a;
    }

    void test30() {
        boolean val1;
        boolean val2;

        val1 = boolnot(true);
        val2 = boolnot(false);
        mynativedumpbool(30, val1);
        mynativedumpbool(30, val2);
    }

    void test31() {
        for (int i = 0; i < 15; i++) {
            mynativedumpint(31, i);
        }
    }

    void test32() {
        for (long i = 0; i < 15; i++) {
            mynativedumplong(32, i);
        }
    }

    void test33() {
        int val;

        val = 1;
        do {
            val *= 2;
            mynativedumpint(33, val);
        } while (val < 1000000);
    }

    void test34() {
        int val;

        val = 0;
        while (val < 20) {
            mynativedumpint(34, val);
            val++;
        }
    }

    /**
     * Only VM can instantiate this class.
     */
    Object() {
        test1();
        test2();
        test3();
        test4();
        test5();
        test6();
        test7();
        test8();
        test9();
        test10();
        test11();
        test12();
        test13();
        test14();
        test15();
        test16();
        test17();
        test18();
        test19();
        test20();
        test21();
        test22();
        test23();
        test24();
        test25();
        test26();
        test27();
        test28();
        test29();
        test30();
        test31();
        test32();
        test33();
        test34();
    }
}
