/*
 *  vhost_stat.c
 *
 *  Copyright (C) 2004  Antonin Karasek <karasek@ceskyserver.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Compiling:
 * gcc -o vhostd vhost_stat.c
 */

/*
 * A small part of code was copied from Devin Watson's
 * Linux Daemon Writing HOWTO
 *
 * Many thanks to him.
 */

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
#include <sys/types.h>
#include <pwd.h>
#include <time.h>

#define HASH_SIZE 1024

/*
 * TODO:
 * 
 * Pipe must be readable for vhostd and nogroup - not nice :(
 * 
 * Report, how many colisions ocurs - in other words - if our hash is
 * good enought.
 *
 * Possibly add timestap to any report.
 *
 * We should print a message if a user vhostd doesn't exits.
 *
 * vhostd fails, if it can't open /tmp/vhostd_report
 * 
 */

struct vhost {
	char *name;
	unsigned long  int bytes;
	unsigned short int count;
	struct vhost *pointer;
};

struct dom {
	char *name;
	struct dom *pointer;
};

struct vhost *field[HASH_SIZE];
	/*
	 * field is my own terminology ;-)
	 */
struct dom *domains=NULL;
time_t from;

unsigned int hash(char *string)
{
int i;
int ret=1;

for(i = 0; i < strlen(string); i++)
	ret = ( ret * string[i] ) % HASH_SIZE;
		
return ret;
}

void report(int n)
{
struct dom *domp;
struct vhost *vhostp;
time_t now;
FILE *out;

out=fopen("/tmp/vhost_report", "a");

now = time(NULL);

fprintf(out, "Network trafic from:\n");
fprintf(out, ctime(&from));
fprintf(out, "To:\n");
fprintf(out, ctime(&now));
fprintf(out, "\n");

domp=domains;

while(domp) {
	fprintf(out, "%s ", domp->name);
	vhostp=field[hash(domp->name)];
	while(vhostp && strcmp(vhostp->name, domp->name))
		vhostp=vhostp->pointer;
	
	if(!vhostp) {
		domp=domp->pointer;
		fprintf(out, "Error in data structure\n");
		continue; }
	
	fprintf(out, "%i GB and %1.2f MB\n", vhostp->count,
			((double)vhostp->bytes)/1048576);
	if(n==SIGHUP) {
		vhostp->count=0;
		vhostp->bytes=0;
	}
	domp=domp->pointer;
}

if(n==SIGHUP)
	printf("Counters are zeroed.\n");

fprintf(out, "\n---------------------------\n\n");

fclose(out);

from = time(NULL);

return;
}

int main(int arg_num, char *args[])
{
char domain[50];
unsigned int in, out, index, i, coli;

pid_t pid, sid;

struct vhost **pointer;
struct dom **domp;
FILE *file;

struct passwd *passwd;

if(arg_num != 2) {
  fprintf(stderr, "You must call this program with exactly one argument\n");
  fprintf(stderr, "with full path to Apache's log.\n");
}


pid = fork();
if (pid < 0) {
	fprintf(stderr,"Unable to fork() child proces\n");
	exit(1); }

if (pid > 0) {	/* We are in parent proces */
	/* TODO: Remove vhostd.pid at exit - atexit() */
	file=fopen("/var/run/vhostd.pid", "w");
	if(!file) {
		fprintf(stderr, "Unable to open file /var/run/vhostd.pid\n");
		exit(1); }
	fprintf(file, "%i", pid);
	fclose(file);
	exit(0); }

sid = setsid();
if (sid < 0) {
	fprintf(stderr, "Unable to create a new SID\n");
	exit(1); }


if ((chdir("/")) < 0) {
	fprintf(stderr, "Unable to chdir to \"/\"\n");
	exit(1); }

/*umask (0);*/

/* Become a nobody */
passwd=getpwnam("vhostd");

if(setgid(passwd->pw_gid) || setuid(passwd->pw_uid)) {
	fprintf(stderr, "Unable to became a nobody. Are you root?\n");
	exit(1); }

/* Open the pipe */
file=fopen(args[1], "r");
if(!file) {
	fprintf(stderr, "Unable to open file %s\n", args[1]);
	fprintf(stderr, "Is the file readable for vhostd?\n");
	exit(1); }


close(STDIN_FILENO);
close(STDOUT_FILENO);
close(STDERR_FILENO);


signal(SIGUSR1, report);
signal(SIGHUP, report);

for(i=0; i < HASH_SIZE; i++)
	field[i]=NULL;

from = time(NULL);

while(1) {
	if(fscanf(file, "%s %i %i", domain, &in, &out)==EOF) {
		for(i=0; !(file=fopen(args[1], "r")) && i < 10; i++) 
			sleep(1);
		if(!file)
			exit(1);
		continue;
	}
	pointer=field + hash(domain);
/*	printf("Domain: %s; hash: %i\n", domain, hash(domain)); */
		/* if *pointer==NULL, we don't evalue strcmp */
	while(*pointer && strcmp((*pointer)->name, domain))
		pointer=&((*pointer)->pointer);
  /* *pointer==NULL || *pointer is pointer to vhost struct for our domain */
	if(!*pointer) {
		*pointer = (struct vhost *)	malloc(sizeof(struct vhost));
		(*pointer)->name = 
			(char *) malloc((strlen(domain) + 1)*sizeof(char));
		strcpy((*pointer)->name, domain);
		(*pointer)->bytes=in + out;
		(*pointer)->count=0;
		(*pointer)->pointer=NULL;
		
		domp=&domains;
		while(*domp)
			domp=&((*domp)->pointer);
		*domp = (struct dom *)		malloc(sizeof(struct dom));
		(*domp)->name =
			(char *) malloc((strlen(domain) + 1)*sizeof(char));
		strcpy((*domp)->name, domain);
		(*domp)->pointer=NULL;
	}
	else {
		(*pointer)->bytes+=in + out;
		if((*pointer)->bytes > 1073741824) {
			(*pointer)->bytes -= 1073741824;
			(*pointer)->count++;
		}
	}	
}	

return 0;
}
