﻿use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;
use URI;

plan tests => 6, (need_lwp);

Apache::TestRequest::user_agent(requests_redirectable => 0);

# Use the virtualhost for this test
Apache::TestRequest::module('ExternalListener');

my $hostport = Apache::TestRequest::hostport();
$hostport =~ m/:(\d+)$/;
my $port = 1 * $1;

#my $config = Apache::Test::config('ExternalListener');
#my $vars = $config->{vars};
#my $port = $vars->{port};
#print 'Port should be [' . $port . "]\n";

# sub parseurl {
#     my ($url) = @_;
#     my $url =~ m#^(https?)://(\s+):?(\d?)(/.*/)$#;
#     my $scheme = $1;
#     my $host   = $2;
#     my $port   = $3;
#     my $path   = $4;
#     
#     return ($scheme, $host, $port, $path);
# }

# Test 1: The baseline, no config at all
{
    my $uri = '/extlistener';
    # Pass in bogus portnumber to see it come out the other end
    my $r = GET $uri, Host => 'foo:4002'; 
    my $u = URI->new($r->header('Location'));
    print "[$u]\n";
#    my @myurl = parseurl $u;
#    print @myurl . "\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host') &&
        t_cmp($u->scheme, 'http', 'Redirect target scheme') &&
        t_cmp($u->port, 4002, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}

# Test 2: Custom port, UCN off
{
    my $uri = '/extlistener/ucnoff';
    my $r = GET $uri, Host => 'foo'; 
    my $u = URI->new($r->header('Location'));
    #print "[$u]\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host') &&
        t_cmp($u->scheme, 'http', 'Redirect target scheme') &&
        t_cmp($u->port, 1234, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}

# Test 3: Custom port, UCN on
{
    my $uri = '/extlistener/ucnon';
    my $r = GET $uri, Host => 'foo'; 
    my $u = URI->new($r->header('Location'));
    #print "[$u]\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'quux', 'Redirect target host') &&
        t_cmp($u->scheme, 'http', 'Redirect target scheme') &&
        t_cmp($u->port, 5678, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}

# Test 4: Default port, custom scheme
{
    my $uri = '/extlistener/scheme';
    # Pass in bogus port number to see it come out the other end
    my $r = GET $uri, Host => 'foo:3434'; 
    my $u = URI->new($r->header('Location'));
    print "[$u]\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host') &&
        t_cmp($u->scheme, 'https', 'Redirect target scheme') &&
        t_cmp($u->port, 3434, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}

# Test 5: Custom port, UCN off, custom scheme
{
    my $uri = '/extlistener/ucnoff/schemeandport';
    my $r = GET $uri, Host => 'foo'; 
    my $u = URI->new($r->header('Location'));
    #print "[$u]\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host') &&
        t_cmp($u->scheme, 'https', 'Redirect target scheme') &&
        t_cmp($u->port, 9012, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}

# Test 6: Custom scheme, custom port set to default HTTPS port
{
    my $uri = '/extlistener/ucnoff/schemeandwellknownport';
    my $r = GET $uri, Host => 'foo'; 
    my $u = URI->new($r->header('Location'));
    print "[$u]\n";
    ok (t_cmp($r->code, 301, 'HTTP response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host') &&
        t_cmp($u->scheme, 'https', 'Redirect target scheme') &&
        t_cmp($u->port, 443, 'Redirect target port') &&
        t_cmp($u->path, "$uri/", 'Redirect target path'));
}
