﻿use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;
use URI;

plan tests => 2, (need_lwp);

Apache::TestRequest::user_agent(requests_redirectable => 0);

# Use the virtualhost for this test
Apache::TestRequest::module('UseCanonicalName');

# Get a URI with missing trailing slash with UseCanonicalName turned on.
# The server should send its configured ServerName.
{
    my $uri = '/ucnon';
    my $r = GET $uri, Host => 'foo';
    my $u = URI->new($r->header('Location'));
    ok (t_cmp($r->code, 301, 'HTTP Response code') &&
        t_cmp($u->host, 'bar', 'Redirect target host')   &&
        t_cmp($u->path, '/ucnon/', 'Redirect target path'));
}

# UseCanonicalName turned off in the subdirectory.
# Server should send back the server name from the Host: header.
{
    my $uri = '/ucnon/ucnoff';
    my $r = GET $uri, Host => 'foo';
    $u = URI->new($r->header('Location'));
    ok (t_cmp($r->code, 301, 'HTTP Response code') &&
        t_cmp($u->host, 'foo', 'Redirect target host')   &&
        t_cmp($u->path, '/ucnon/ucnoff/', 'Redirect target path'));
}
