#!/usr/bin/ksh
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#

# buildaix.ksh: This script builds an AIX fileset of Apache APR
# see build/aix/aixinfo for name

lslpp -L bos.adt.insttools >/dev/null
[[ $? -ne 0 ]] && echo "must have bos.adt.insttools installed" && exit -1

. build/aix/aixinfo
LAYOUT=AIX
TEMPDIR=/var/tmp/$USER/${NAME}.${VERSION}
rm -rf $TEMPDIR

## strange interaction between install and libtool requires a regular install
## for all the links to succeed in the TEMPDIR

export CFLAGS=-O2

if [[ ! -e ./Makefile ]]
then
echo "+ ./configure --enable-layout=$LAYOUT > build/aix/configure.out"
./configure \
 	--enable-layout=$LAYOUT \
 	> build/aix/configure.out
else
	echo $0: using existing Makefile
	echo $0: run make distclean to get a standard AIX configure
	echo
	ls -l ./Makefile config.*
	echo
fi

echo "+ make > build/aix/make.out"
make > build/aix/make.out

echo "+ make install DESTDIR=$TEMPDIR > build/aix/install.out"
make install DESTDIR=$TEMPDIR > build/aix/install.out
[[ $? -ne 0 ]] && echo 'make install' returned an error && exit -1

echo "+ build/aix/mkinstallp.ksh $TEMPDIR > build/aix/mkinstallp.out"
build/aix/mkinstallp.ksh $TEMPDIR > build/aix/mkinstallp.out
[[ $? -ne 0 ]] && echo mkinstallp.ksh returned an error && exit -1

rm -rf $TEMPDIR

# list installable fileset(s)
echo ==============================
installp -d build/aix -L
echo ==============================
