/*
 * Decompiled with CFR 0.152.
 */
package brushed.jspwiki.tableplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

public class Table
implements WikiPlugin {
    private static Logger log = Logger.getLogger(Table.class);
    private WikiContext m_context;
    private StringBuffer m_result = new StringBuffer();
    private String m_style;
    private String m_style_header;
    private String m_style_data;
    private String m_styleRowEven;
    private String m_styleRowOdd;
    private int m_startRow;
    public static final String PARAM_BODY = "_body";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_STYLE_HEADER = "headerStyle";
    public static final String PARAM_STYLE_DATA = "dataStyle";
    public static final String PARAM_STYLE_ROW_ODD = "evenRowStyle";
    public static final String PARAM_STYLE_ROW_EVEN = "oddRowStyle";
    public static final String PARAM_ROW_NUMBER = "rowNumber";

    public String execute(WikiContext wikiContext, Map<String, String> map) throws PluginException {
        this.m_context = wikiContext;
        if (wikiContext.getPage() == null) {
            return "";
        }
        String string = map.get(PARAM_BODY);
        if (string == null) {
            return "";
        }
        this.m_style = map.get(PARAM_STYLE);
        this.m_style_header = map.get(PARAM_STYLE_HEADER);
        this.m_style_data = map.get(PARAM_STYLE_DATA);
        this.m_styleRowEven = map.get(PARAM_STYLE_ROW_EVEN);
        this.m_styleRowOdd = map.get(PARAM_STYLE_ROW_ODD);
        this.m_startRow = TextUtil.parseIntParameter((String)map.get(PARAM_ROW_NUMBER), (int)0);
        log.info((Object)"TABLE plugin invoked\n");
        this.m_result = new StringBuffer("");
        this.processTable(string);
        return this.m_result.toString();
    }

    protected void processTable(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        int n4 = 0;
        TableCell tableCell = null;
        ArrayList<TableCell> arrayList = new ArrayList<TableCell>();
        ArrayList<List<TableCell>> arrayList2 = new ArrayList<List<TableCell>>();
        for (n = 0; n < n2; ++n) {
            char c = stringBuffer.charAt(n);
            if (tableCell == null) {
                if (c == '\n') {
                    n4 = 0;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    n4 = 1;
                    continue;
                }
                if (c == '|' && n4 == 0) {
                    tableCell = new TableCell();
                    n = tableCell.registerStart(stringBuffer, n);
                    arrayList.add(tableCell);
                    n4 = 2;
                    continue;
                }
                log.info((Object)("ERR: CHAR outside table \"" + c + "\""));
                break;
            }
            if (this.startsWith("[{", stringBuffer, n)) {
                ++n3;
                ++n;
                continue;
            }
            if (this.startsWith("}]", stringBuffer, n)) {
                --n3;
                ++n;
                continue;
            }
            if (n3 > 0) continue;
            if (bl) {
                if (!this.startsWith("}}}", stringBuffer, n)) continue;
                bl = false;
                n += 2;
                continue;
            }
            if (this.startsWith("{{{", stringBuffer, n)) {
                bl = true;
                n += 2;
                continue;
            }
            if (bl2) {
                if (!this.startsWith("}}", stringBuffer, n)) continue;
                bl2 = false;
                ++n;
                continue;
            }
            if (this.startsWith("{{", stringBuffer, n)) {
                bl2 = true;
                ++n;
                continue;
            }
            if (bl4) {
                if (!this.startsWith("%%", stringBuffer, n)) continue;
                bl4 = false;
                ++n;
                continue;
            }
            if (this.startsWith("%%", stringBuffer, n)) {
                bl4 = true;
                ++n;
                continue;
            }
            if (bl3) {
                if (c != ']') continue;
                bl3 = false;
                continue;
            }
            if (c == '[') {
                bl3 = true;
                continue;
            }
            if (tableCell.cssStyle) {
                tableCell.handleCss(stringBuffer, n);
                continue;
            }
            if (this.startsWith("~#", stringBuffer, n)) {
                ++n;
                continue;
            }
            if (c == '#') {
                stringBuffer.deleteCharAt(n);
                stringBuffer.insert(n, arrayList2.size() + this.m_startRow);
                n2 = stringBuffer.length();
                continue;
            }
            if (this.startsWith("~|", stringBuffer, n)) {
                ++n;
                continue;
            }
            if (this.startsWith("\n|", stringBuffer, n) && (n4 == 2 || n4 == 4)) {
                tableCell.registerEnd(stringBuffer, n - 1);
                tableCell = new TableCell();
                n = tableCell.registerStart(stringBuffer, n + 1);
                arrayList.add(tableCell);
                n4 = 4;
                continue;
            }
            if (c == '|' && (n4 == 2 || n4 == 3)) {
                tableCell.registerEnd(stringBuffer, n);
                tableCell = new TableCell();
                n = tableCell.registerStart(stringBuffer, n);
                arrayList.add(tableCell);
                n4 = 3;
                continue;
            }
            if (c == '\n' && (n4 == 2 || n4 == 4)) {
                n4 = 5;
                continue;
            }
            if (c == '\n' && (n4 == 3 || n4 == 5)) {
                tableCell.registerEnd(stringBuffer, n);
                arrayList2.add(arrayList);
                arrayList = new ArrayList();
                tableCell = null;
                n4 = 0;
                continue;
            }
            if (n4 != 5 || Character.isWhitespace(c)) continue;
            n4 = 4;
        }
        if (tableCell != null) {
            tableCell.registerEnd(stringBuffer, n);
            arrayList2.add(arrayList);
        }
        this.processTableFlush(arrayList2, stringBuffer);
    }

    protected void processTableFlush(List<List<TableCell>> list, StringBuffer stringBuffer) {
        if (list.isEmpty()) {
            return;
        }
        this.m_result.append("<table border='1' class='wikitable'");
        if (this.m_style != null) {
            this.m_result.append(" style=\"" + this.m_style + "\" ");
        }
        this.m_result.append("> \n");
        for (int i = 0; i < list.size(); ++i) {
            List<TableCell> list2 = list.get(i);
            this.m_result.append("<tr>\n");
            for (int j = 0; j < list2.size(); ++j) {
                int n;
                int n2;
                TableCell tableCell = list2.get(j);
                if (tableCell.colspan || tableCell.rowspan) continue;
                if (tableCell.isHeader) {
                    this.m_result.append("<th");
                    if (this.m_style_header != null) {
                        this.m_result.append(" style=\"" + this.m_style_header + "\"");
                    }
                } else {
                    this.m_result.append("<td");
                    String string = "";
                    if (this.m_style_data != null) {
                        string = string + this.m_style_data + " ";
                    }
                    if (tableCell.cssStart != -1) {
                        string = string + stringBuffer.substring(tableCell.cssStart, tableCell.cssEnd);
                    }
                    if (this.m_styleRowEven != null && i % 2 == 0) {
                        string = string + this.m_styleRowEven + " ";
                    }
                    if (this.m_styleRowOdd != null && i % 2 != 0) {
                        string = string + this.m_styleRowOdd;
                    }
                    if (string != "") {
                        this.m_result.append(" style=\"" + string + "\"");
                    }
                }
                if ((n2 = this.getColSpan(list, i, j)) > 1) {
                    this.m_result.append(" colspan='" + n2 + "'");
                }
                if ((n = this.getRowSpan(list, i, j)) > 1) {
                    this.m_result.append(" rowspan='" + n + "'");
                }
                this.m_result.append(">");
                this.m_result.append(this.m_context.getEngine().textToHTML(this.m_context, stringBuffer.substring(tableCell.start, tableCell.end)));
                if (tableCell.isHeader) {
                    this.m_result.append("</th>\n");
                    continue;
                }
                this.m_result.append("</td>\n");
            }
            this.m_result.append("</tr>\n");
            list2.clear();
        }
        list.clear();
        this.m_result.append("</table>\n");
    }

    protected int getColSpan(List<List<TableCell>> list, int n, int n2) {
        int n3 = 1;
        List<TableCell> list2 = list.get(n);
        while (++n2 < list2.size()) {
            TableCell tableCell = list2.get(n2);
            if (!tableCell.colspan) break;
            ++n3;
        }
        return n3;
    }

    protected int getRowSpan(List<List<TableCell>> list, int n, int n2) {
        int n3 = 1;
        while (++n < list.size()) {
            List<TableCell> list2 = list.get(n);
            if (n2 >= list2.size()) continue;
            TableCell tableCell = list2.get(n2);
            if (!tableCell.rowspan) break;
            ++n3;
        }
        return n3;
    }

    protected boolean startsWith(String string, StringBuffer stringBuffer, int n) {
        return stringBuffer.indexOf(string, n) == n;
    }

    private class TableCell {
        public int start;
        public int end;
        public boolean isHeader;
        public boolean colspan;
        public boolean rowspan;
        public boolean cssStyle;
        public int cssBracket;
        public int cssStart;
        public int cssEnd;

        private TableCell() {
        }

        public int registerStart(StringBuffer stringBuffer, int n) {
            char c;
            this.end = -1;
            this.cssStart = -1;
            this.cssEnd = -1;
            this.cssStyle = false;
            this.cssBracket = 0;
            this.colspan = false;
            this.rowspan = false;
            this.isHeader = false;
            if (n + 1 < stringBuffer.length() && (c = stringBuffer.charAt(n + 1)) == '|') {
                this.isHeader = true;
                ++n;
            }
            if (n + 1 < stringBuffer.length()) {
                c = stringBuffer.charAt(n + 1);
                if (c == '<') {
                    this.colspan = true;
                    ++n;
                } else if (c == '^') {
                    this.rowspan = true;
                    ++n;
                } else if (c == '(') {
                    this.cssStyle = true;
                    this.cssBracket = 1;
                    ++n;
                }
            }
            this.start = n + 1;
            return n;
        }

        public void handleCss(StringBuffer stringBuffer, int n) {
            char c = stringBuffer.charAt(n);
            if (c == '(') {
                ++this.cssBracket;
            } else if (c == ')') {
                --this.cssBracket;
            }
            if (this.cssBracket == 0) {
                this.cssStyle = false;
                this.cssStart = this.start;
                this.cssEnd = n;
                this.start = this.cssEnd + 1;
            }
        }

        public TableCell registerEnd(StringBuffer stringBuffer, int n) {
            this.end = n;
            log.debug((Object)("Cell [" + stringBuffer.substring(this.start, this.end) + "]"));
            return this;
        }
    }
}

