function isMobile() {
  if (parent && parent.$('#mobilecheck')) {
    // checking from inside an iframe
    if (parent.$('#mobilecheck').css('display') == 'block') {
      return true;
    } else {
      return false;
    }
  } else if ($('#mobilecheck').length) {
    if ($('#mobilecheck').css('display') == 'block') {
      return true;
    }
  }
  return false;
}
function isFrame() {
  if (window.location != window.parent.location) {
    return true;
  }
  return false;
}

// Ipad Orientation Fix
if (typeof(window.addEventListener) == 'function') {
  window.addEventListener("orientationchange", function() {
    console.log('orientation change:'+window.orientation);
    if (window.orientation == 180 || window.orientation == 0) {
      // switched to portrait mode
      console.log('portrait');
      headerheight = $('#header').height();
      footerheight = $('#frame-footer').height();
      screenheight = screen.height;
      $('#mainscreen').height(screenheight - (headerheight + footerheight));
      console.log('!!! screen='+screenheight+' header='+headerheight+' footer='+footerheight);
      
    }
//    if ($(window).width() == 1024 && $("#taskbar").offset().top != 50)
//      $("#taskbar").css({top: "-56px"});
  }, false);
}

handleMobileToggle = function (){
}

rcmail_mobile = {};
rcmail_mobile.animate = (typeof($('body').animate) == 'function') ? true : false;
rcmail_mobile.toggle_folders = function() {
  $('#mobile_folders').empty();
  $('#mobile .header').after('<div id="mobile_folders" class="mobile_menumodal"></div>');
  for (var mailbox in rcmail.env.mailboxes) {
    var name = rcmail.env.mailboxes[mailbox].name;
    var id = rcmail.env.mailboxes[mailbox].id;
    if (id == rcmail.env.mailbox) {
      $('#mobile_folders').append('<div class="selected">'+name+'</div>');
    } else {
      $('#mobile_folders').append('<div onclick="rcmail_mobile.close_menu();$(\'#mobile .list\').empty();rcmail.command(\'list\',\''+id+'\',this);">'+name+'</div>');
    }
  }
  $('#mobile_folders').toggle();
  $('#mobile #underlay').toggle();
  $('#mobile .header span.folders').toggleClass('active');
};
rcmail_mobile.toggle_menu = function() {
  $('#mobile_menu').toggle();
  $('#mobile #underlay').toggle();
  $('#mobile .header span.menu').toggleClass('active');
};
rcmail_mobile.close_menu = function() {
  // fires to close both the menu and folders modals
  $('#mobile_menu').hide();
  $('#mobile_folders').hide();
  $('#mobile #underlay').hide();
  $('#mobile .header span.folders').removeClass('active');
  $('#mobile .header span.menu').removeClass('active');
};
rcmail_mobile.buildmap = {
  'back':["rcmail.command('switch-task','mail',this,event)",'Back'],
  'mail':["rcmail.command('switch-task','mail',this,event)",'Mail'],
  'back-addressbook':["rcmail.task='tmp';rcmail.command('switch-task','addressbook',this,event)",'Back'],
  'back-settings':["rcmail.task='tmp';rcmail.command('switch-task','settings',this,event)",'Back'],
  'back-settings-folders':["rcmail.command('folders','',this,event)",'Back'],
  'back-settings-identities':["rcmail.command('identities','',this,event)",'Back'],
  'back-mail':["rcmail.task='tmp';rcmail.command('switch-task','mail',this,event)",'Back'],
  'addressbook':["rcmail.command('switch-task','addressbook',this,event)",'Addressbook'],
  'back-show':["rcmail.command('show','',this,event)",'Back'],
  'back-iframe':["rcmail_mobile.back_iframe()",'Back'],
  'send':["rcmail.command('send','',this,event)",'Send'],
  'draft':["rcmail.command('draft','',this,event)",'Draft'],
  'reply':["rcmail.command('reply','',this,event)",'Reply'],
  'delete':["rcmail_mobile.delete_messages(event)",'Delete','select'],
  'delete-next':["rcmail.command('delete','',this,event)",'Delete'],
  'spam':["rcmail_mobile.markasjunk2()",'Spam','select'],
  'checkmail':["rcmail_mobile.first_page()",'Check Mail'],
  'folders':["rcmail_mobile.toggle_folders()",'Folders'],
  'compose':["rcmail.command('compose','',this,event)",'Compose'],
  'groups':["rcmail_mobile.toggle_groups()",'Groups'],
  'menu':["rcmail_mobile.toggle_menu()",'Menu'],
  'addcc':["UI.show_header_row('cc')",'Add Cc'],
  'addbcc':["UI.show_header_row('bcc')",'Add Bcc'],
  'spellcheck':["rcmail_mobile.close_menu();return rcmail.command('spellcheck','',this,event)",'Spelling'],
  'attachfile':["rcmail_mobile.close_menu();UI.show_uploadform()",'Attach'],
  'reply-all':["rcmail.command('reply-all','',this,event)",'Reply All'],
  'forward':["rcmail.command('forward','',this,event)",'Forward'],
  'forward-attachment':["rcmail.command('forward-attachment','',this,event)",'Forward as attachment'],
  'markread':["rcmail.command('mark','read',this,event)",'Mark as read','select'],
  'markunread':["rcmail.command('mark','unread',this,event)",'Mark as unread','select'],
  'flag':["rcmail.command('mark','flagged',this,event)",'Mark as flagged','select'],
  'unflag':["rcmail.command('mark','unflagged',this,event)",'Mark as unflagged','select'],
  'settings':["rcmail.command('switch-task','settings',this,event)",'Settings'],
};
rcmail_mobile.build = function(args) {
  $('body').prepend('<div id="mobile"><div id="underlay" onclick="rcmail_mobile.close_menu()"></div><div class="header"></div><div id="header_spacer"></div></div>');
  if (args.toolbar) {
    for (i in args.toolbar) {
      var option = args.toolbar[i];
      var a = option.split('-');
      var button = a[0];
      if (rcmail_mobile.buildmap[option]) {
        if (rcmail_mobile.buildmap[option][2]) { button += ' '+rcmail_mobile.buildmap[option][2]; }
        $('#mobile .header').append('<span class="button '+button+'" onclick="'+rcmail_mobile.buildmap[option][0]+'"></span>');
      }
    }
  }
  $('#mobile .header').after('<div id="mobile_menu" class="mobile_menumodal"></div>');
  if (args.menu) {
    for (i in args.menu) {
      var option = args.menu[i];
      if (option == '---') {
        $('#mobile_menu').append('<div><hr/></div>');
      } else if (rcmail_mobile.buildmap[option]) {
        var cls = '';
        if (rcmail_mobile.buildmap[option][2]) { cls = ' class="'+rcmail_mobile.buildmap[option][2]+'"'; }
        $('#mobile_menu').append('<div onclick="'+rcmail_mobile.buildmap[option][0]+'"'+cls+'>'+rcmail_mobile.buildmap[option][1]+'</div>');
      }
    }
  }
  $('#mobile_menu').append('<div onclick="return rcmail.command(\'logout\',\'\',this,event)">Logout</div>');
  if (args.list) {
    $('#mobile').append('<div class="countheader"></div><div id="count_spacer"></div><div class="list"></div>');
    if (rcmail.env.infinitescroll) {
      // add scroll handler
      $(document).on("scrollstop", function (e) {
        var screenHeight = $(window).height();
        var contentHeight = $("#mobile .list").outerHeight();
        var scrolled = $(window).scrollTop();
        var scrollEnd = contentHeight - screenHeight;
        if (scrolled >= scrollEnd) {
          var endpage = $('#mobile .list').attr('endpage') * 1;;
          if (endpage < rcmail.env.pagecount) {
            rcmail_mobile.next_page();
          }
        }
      });
    }
  }
  // set height on menu spacer (count_spacer happens elsewhere)
  $('#header_spacer').height($('#mobile .header').outerHeight());
};

rcmail_mobile.click_message = function(event) {
  var elem = event.target;
  if ($(elem).hasClass('selector') || $(elem).parent().hasClass('selector')) {
    if ($(elem).prop('nodeName') == 'SPAN') {
      elem = $(event.target).parent().parent();
    } else {
      elem = $(event.target).parent();
    }
    if ($(elem).attr('uid') && !$(elem).hasClass('deleted')) {
      var uid = $(elem).attr('uid') * 1;
      if ($(elem).hasClass('selected')) {
        $(elem).removeClass('selected');
        rcmail.message_list.selection = jQuery.grep(rcmail.message_list.selection, function(value) {
          return value !== uid;
        });
      } else {
        $(elem).addClass('selected');
        var list = rcmail.message_list || rcmail.contact_list;
        list.selection.push(uid);
        if (!list.rows[uid]) {
          // fake out the message_list object if the message isn't on the roundcube list copy
          var classes = $(elem).attr('class').split(/\s+/);
          var obj = {};
          $($(elem).attr('class').split(/\s+/)).each(function(i,cls) {
            obj[cls] = true;
          });
          list.rows[uid] = obj;
        }
      }
      rcmail_mobile.update_select();
    }
  } else {
    if ($(elem).prop('nodeName') == 'SPAN') {
      elem = $(elem).parent().parent();
    } else if ($(elem).prop('nodeName') == 'DIV') {
      elem = $(elem).parent();
    }
    if ($(elem).attr('uid') && !$(elem).hasClass('deleted')) {
      rcmail.env.uid = $(elem).attr('uid') * 1;
      if (rcmail_mobile.animate) {
        $(elem).animate({'background-color':rcmail_mobile.select_color});
      } else {
        $(elem).css({'background-color':rcmail_mobile.select_color});
      }
      if (rcmail.env.task == 'mail') {
        rcmail.show_message($(elem).attr('uid') * 1, false, false);
      } else if (rcmail.env.task == 'addressbook') {
        rcmail.load_contact($(elem).attr('uid') * 1, 'show', false);
      }
    }
  }
};

rcmail_mobile.back_iframe = function() {
  $('#mobile .header .button.back').attr('onclick','rcmail.command(\'switch-task\',\'mail\',this,event)');
  $('#settings-sections').show();
  $('#sectionslist').show();
  $('#preferences-frame').attr('src','skins/larry/watermark.html');
  $('#preferences-box').css('left',$('#preferences-box').attr('origleft'));
  $('#sections-table .selected').removeClass('selected');
  $('#sections-table .selected').removeClass('focused');
  if (rcmail.sections_list) { rcmail.sections_list.selection = []; }
};

rcmail_mobile.delete_messages = function(event) {
  rcmail.delete_messages(event);
};

rcmail_mobile.markasjunk2 = function() {
  if (rcmail.env.mailboxes[rcmail.env.mailbox]['class'] && rcmail.env.mailboxes[rcmail.env.mailbox]['class'] == 'junk') {
    rcmail_markasjunk2('not_junk');
  } else {
    rcmail_markasjunk2('junk');
  }
};

rcmail_mobile.update_select = function() {
  // toggle the disabled class on things that are only allowed when there are selected items
  if (rcmail.message_list && rcmail.message_list.selection.length > 0) {
    $('#mobile .header .button.select').removeClass('disabled');
    $('#mobile #mobile_menu .select').removeClass('disabled');
  } else {
    $('#mobile .header .button.select').addClass('disabled');
    $('#mobile #mobile_menu .select').addClass('disabled');
  }
};

rcmail_mobile.next_page = function(evt) {
  var endpage = $('#mobile .list').attr('endpage');
  rcmail.env.current_page = endpage * 1; /* grab true last page for new data load */
//temp
rcmail.env.infinitescroll = true;
  if (!rcmail.env.infinitescroll) { $('#mobile .list').empty(); }
  rcmail.command('nextpage','',this,evt);
};
rcmail_mobile.prev_page = function(evt) {
  var startpage = $('#mobile .list').attr('startpage');
  rcmail.env.current_page = startpage * 1; /* grab true start page for new data load */
//temp
rcmail.env.infinitescroll = true;
  if (!rcmail.env.infinitescroll) { $('#mobile .list').empty(); }
  rcmail.command('previouspage','',this,evt);
};
rcmail_mobile.first_page = function(evt) {
  // load first page, reset list
  rcmail.env.current_page = 2;
  $('#mobile .list').empty();
  rcmail.message_list.selection = [];
  rcmail.list_page('prev');
};
rcmail_mobile.last_page = function(evt) {
  // load last page, reset list
  rcmail.env.current_page = rcmail.env.pagecount - 1;
  $('#mobile .list').empty();
  rcmail.message_list.selection = [];
  rcmail.command('nextpage','',this,evt);
};

$(document).on('rcmail_init', function() {
  // add mobile class to deal with small iframes in normal UI
  // set mobile cookie for plugin to read mobile state
  if (isMobile()) { 
    $('html').addClass('mobile'); 
    $.cookie('rcube_mobile',1,{'expires':1,'path':'/'});
  } else {
    $.cookie('rcube_mobile',0,{'expires':1,'path':'/'});
  }

  // grab the select colour from css
  rcmail_mobile.select_color = $('#mobilecheck').css('color');

  if (isMobile() && isFrame()) {
    // add a class so we can style these
console.log('FRAME');
    $('body').addClass('mobile');
  }

//temp
rcmail.env.infinitescroll = true;

  rcmail.addEventListener('enable-command',function(evt) {
    if (evt.command == 'toggle-editor') {
      // force no-html mode for mobile. actionafter event for compose happens before we can reliably add a handler
      // but the toggle-editor event is possible to use instead
      $("input[name='_is_html']").val(0);
    }
  });
  rcmail.addEventListener('init',function(evt) {
console.log('INIT task='+rcmail.env.task+' action='+rcmail.env.action);
    if (rcmail.env.task == 'mail') {
      if (rcmail.env.action == '') {
        // mail list view
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['checkmail','folders','compose','delete','spam','menu'],'menu':['markread','markunread','flag','unflag','---','addressbook','settings'],'list':true});
          $('#mobile .list').bind('click',rcmail_mobile.click_message); // click handler for viewing or selecting a message
          //$('#mobile .list .container').bind('tap',rcmail_mobile.view_message); // click handler for opening a message
          //$('#mobile .list .selector').bind('tap',rcmail_mobile.select_message); // select a message
        }
      } else if (rcmail.env.action == 'show') {
        // single message view
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['back','reply','deletenext','spamnext','menu'],'menu':['reply-all','forward','forward-attachment','markread','markunread','flag','unflag','---']});
        }
        $('#mailviewsplitterv').hide();
        $('#mailview-right').css('left',0);
    
      } else if (rcmail.env.action == 'compose') {
        // compose view
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['back','send','draft','menu'],'menu':['addcc','addbcc','spellcheck','attachfile','---']});
        }
        if (isMobile()) {
          // fix style
          $('#composeview-right').css('left',0);
          $('#composesplitterv').hide();
          // default of 70 cols is not wide enough to display quoted text
          // find width of 78 cols and set it as min-width so larry's ui.js
          // can't shrink it so small that text wraps with the quote markers incorrectly
          $('#composebody').attr('cols','78').css('width','auto').css('min-width',$('#composebody').width()+'px');
        }
      }
    } else if (rcmail.env.task == 'addressbook') {
      if (rcmail.env.action == '') {
        // addressbook page
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['back','groups','menu'],'menu':['mail','settings'],'list':true});
          $('#mobile .header').after('<div id="mobile_groups" class="mobile_menumodal"></div>');
          $('#mobile .list').bind('click',rcmail_mobile.click_message);
        }
      } else if (rcmail.env.action == 'show') {
        // contact page
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['back-addressbook','menu'],'menu':['mail','settings']});
        }
      } else if (rcmail.env.action == 'edit') {
        // contact edit page
        if ($('#mobile').length == 0) {
          rcmail_mobile.build({'toolbar':['back-show','menu'],'menu':['mail','settings']});
        }
      }
      
    } else if (rcmail.env.task == 'settings') {
      if ($('#mobile').length == 0) {
        switch (rcmail.env.action) {
          case '':
            rcmail_mobile.build({'toolbar':['back-mail','menu'],'menu':['mail','addressbook']});
            break
          case 'edit-folder':
            rcmail_mobile.build({'toolbar':['back-settings-folders','menu'],'menu':['mail','addressbook']});
            break;
          case 'edit-identity':
            rcmail_mobile.build({'toolbar':['back-settings-identities','menu'],'menu':['mail','addressbook']});
            break;
          default:
            rcmail_mobile.build({'toolbar':['back-settings','menu'],'menu':['mail','addressbook']});
        }
        if (isMobile()) {
          // splitters are added by javascript, hide them
          $('div[id*="splitter"]').hide();

          // fix up widths
          switch (rcmail.env.action) {
            case '':
              $('#settings-sections').css('width','auto');
              $('#sectionslist').css('width','auto');
              break
            case 'folders':
              $('#settings-sections').hide();
              $('#folderslist').css('width',$('#folderslist-content').outerWidth());
              break;
            case 'identities':
              $('#settings-sections').hide();
              $('#identitieslist').css('width',$('#identitieslist .scroller').outerWidth());
              break;
            case 'responses':
              $('#settings-sections').hide();
              // responses has #identitieslist instead of #responseslist
              $('#identitieslist').css('width',$('#identitieslist .scroller').outerWidth());
              break;
            default:
              $('#settings-sections').hide();
          }
        }
      }
    }
  });
  rcmail.addEventListener('insertrow',function(evt) {
    var container = $("#mobile .list span[page='"+rcmail.env.current_page+"']");
    if (container.length == 0) {
      var startpage = $('#mobile .list').attr('startpage');
      if (startpage && rcmail.env.current_page < startpage * 1) {
        $("#mobile .list").prepend('<span class="page" page="'+rcmail.env.current_page+'"></span>');
      } else {
        $("#mobile .list").append('<span class="page" page="'+rcmail.env.current_page+'"></span>');
      }
      container = $("#mobile .list span[page='"+rcmail.env.current_page+"']");
    }
    if (rcmail.env.task == 'mail') {
      // mail list view
      var tr = $('#'+evt.row.id);
      var cls = ' ';
      cls += (($(tr).hasClass('deleted')) == true) ? 'deleted' : '';
      cls += (($(tr).hasClass('flagged')) == true) ? 'flagged' : '';
      cls += (($(tr).hasClass('unread')) == true) ? 'unread' : '';
      var fromto = tr.find('.fromto .rcmContactAddress').text() || tr.find('.from .rcmContactAddress').text() || tr.find('.tofrom .rcmContactAddress').text();;
      var subject = tr.find('.subject a span').text();
      var date = tr.find('.date').text();
      var size = tr.find('.size').text();
      container.append('<div uid="'+evt.uid+'" class="message '+cls+'"><div class="selector"><span>&nbsp;<br/>&nbsp;<br/>&nbsp;</span></div><div class="container"><span class="subject">'+subject+'</span><span class="fromto">'+fromto+'</span><span class="date">'+date+'</span><span class="size">'+size+'</span></div></div>');
    } else if (rcmail.env.task == 'addressbook') {
      var tr = $('#rcmrow'+evt.cid);
      var name = tr.find('.name').text();
      container.append('<div uid="'+evt.cid+'" class="contact"><div class="selector"><span>&nbsp;</span></div><div class="container"><span class="name">'+name+'</span></div></div>');
    } else {
console.log('INIT task='+rcmail.env.task+' action='+rcmail.env.action);
      rcmail.TMP1 = evt;
    }
  });
  rcmail.addEventListener('listupdate',function(evt) {
    var pages = $('#mobile .list span.page');
    var startpage = 0;
    var endpage = 0;
    if (pages.length == 0) {
      // initial view
      startpage = rcmail.env.current_page;
      endpage = rcmail.env.current_page;
    } else {
      startpage = $(pages[0]).attr('page') * 1;
      endpage = $(pages[pages.length - 1]).attr('page');
    }

    $('#mobile .list').attr('startpage',startpage);
    $('#mobile .list').attr('endpage',endpage);

    var startmsg = startpage * rcmail.env.pagesize - rcmail.env.pagesize + 1;
    var endmsg;
    if (rcmail.env.task == 'mail') {
      endmsg = startmsg + $('#mobile .list').find('div.message').length - 1;
    } else {
      endmsg = startmsg + $('#mobile .list').find('div.contact').length - 1;
      var re = /.*(\d+)$/;
      var string = $('#rcmcountdisplay').text();
      var match = re.exec(string);
      rcmail.env.messagecount = match[1];
    }
    var html = '<span class="subtitle">';
    if (rcmail.env.task == 'mail') {
      html += rcmail.env.mailboxes[rcmail.env.mailbox].name+':</span>';
    } else {
      var name = $('#directorylist .selected>a').text();
      html += name+':</span>';
    }
    html += '<span class="countdisplay">'+startmsg+' to '+endmsg+' of '+rcmail.env.messagecount+'</span><span class="pagenavbuttons">';
    if (startpage == 1) {
      html += '<span class="button firstpage disabled" href="#"></span>';
    } else {
      html += '<span class="button firstpage" href="#" onclick="rcmail_mobile.first_page()"></span>';
    }
    if (startpage > 1) {
      html += '<span class="button prevpage" href="#" onclick="rcmail_mobile.prev_page()"></span>';
    } else {
      html += '<span class="button prevpage disabled" href="#"></span>';
    }
    if (endpage < rcmail.env.pagecount) {
      html += '<span class="button nextpage" href="#" onclick="rcmail_mobile.next_page()"></span>';
      html += '<span class="button lastpage" href="#" onclick="rcmail_mobile.last_page()"></span>';
    } else {
      html += '<span class="button nextpage disabled" href="#"></span>';
      html += '<span class="button lastpage disabled" href="#"></span>';
    }
    html += "</span>";
    $('#mobile .countheader').html(html);
    $('#count_spacer').height($('#mobile .countheader').outerHeight());
    rcmail_mobile.update_select();
  });
  rcmail.addEventListener('requestmark',function(postdata){
    // this is called when messages are flagged or marked as read/unread/deleted
    // store the uid list, as when marked delete, rcmail.message_list.selection
    // will be cleared before we get a chance to act on it
    rcmail_mobile.selection = postdata['_uid'].split(',');
    rcmail_mobile.markaction = postdata['_flag'];
  });
  rcmail.addEventListener('responseaftermark',function(evt) {
    if (rcmail_mobile.selection) {
      // this is only called from mobile list view
      for (var i in rcmail_mobile.selection) {
        // read how roundcube updated the message list and update our cloned copy
        var uid = rcmail_mobile.selection[i];
        var tr = $('#rcmrow'+uid);
        var elem = $('[uid="'+uid+'"]');
        if (tr.length > 0) {
          var deleted = ($(tr).hasClass('deleted')) == true;
          var flagged = ($(tr).hasClass('flagged')) == true;
          var unread = ($(tr).hasClass('unread')) == true;
          (deleted) ? $(elem).addClass('deleted') : $(elem).removeClass('deleted');
          (flagged) ? $(elem).addClass('flagged') : $(elem).removeClass('flagged');
          (unread) ? $(elem).addClass('unread') : $(elem).removeClass('unread');
        } else {
          // message not on roundcube list copy, assume it flagged ok
          if (rcmail_mobile.markaction == 'delete') {
            $(elem).addClass('deleted');
            $(elem).removeClass('unread'); // TODO: check actual setting value for this
          } else if (rcmail_mobile.markaction == 'read') {
            $(elem).removeClass('unread');
          } else if (rcmail_mobile.markaction == 'unread') {
            $(elem).addClass('unread');
          } else if (rcmail_mobile.markaction == 'flagged') {
            $(elem).addClass('flagged');
          } else if (rcmail_mobile.markaction == 'unflagged') {
            $(elem).removeClass('flagged');
          }
        }
      }
      $('#mobile .list .selected').removeClass('selected');
      rcmail.message_list.selection = [];
      delete rcmail_mobile.selection;
      delete rcmail_mobile.markaction;
      rcmail_mobile.update_select();
    }
  });
  rcmail.addEventListener('requestmove',function(postdata){
    // this is called when messages are moved
    // store the uid list, as rcmail.message_list.selection
    // will be cleared before we get a chance to act on it
    rcmail_mobile.selection = postdata['_uid'].split(',');
  });
  rcmail.addEventListener('responseaftermove',function(evt) {
    if (rcmail_mobile.selection) {
      // this is only called from mobile
      for (var i in rcmail_mobile.selection) {
        // read how roundcube updated the message list and update our cloned copy
        var uid = rcmail_mobile.selection[i];
        if ($('#rcmrow'+uid).length > 0) {
          if ($('#rcmrow'+uid).css('display') == 'none') {
            // removed
            $('[uid="'+uid+'"]').remove();
          }
        } else {
          // message not on roundcube list copy, assume it removed ok
          $('[uid="'+uid+'"]').remove();
        }
      }
      rcmail.message_list.selection = [];
      delete rcmail_mobile.selection;
      $('#mobile .list .selected').removeClass('selected');
      rcmail_mobile.update_select();
      rcmail.triggerEvent('listupdate'); // our event fires after this has already been triggered, so trigger it again
    }
  });
});

/*!
 * jQuery Cookie Plugin v1.4.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2006, 2014 Klaus Hartl
 * Released under the MIT license
 */
(function (factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD
    define(['jquery'], factory);
  } else if (typeof exports === 'object') {
    // CommonJS
    factory(require('jquery'));
  } else {
    // Browser globals
    factory(jQuery);
  }
}(function ($) {

  var pluses = /\+/g;

  function encode(s) {
    return config.raw ? s : encodeURIComponent(s);
  }

  function decode(s) {
    return config.raw ? s : decodeURIComponent(s);
  }

  function stringifyCookieValue(value) {
    return encode(config.json ? JSON.stringify(value) : String(value));
  }

  function parseCookieValue(s) {
    if (s.indexOf('"') === 0) {
      // This is a quoted cookie as according to RFC2068, unescape...
      s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
    }

    try {
      // Replace server-side written pluses with spaces.
      // If we can't decode the cookie, ignore it, it's unusable.
      // If we can't parse the cookie, ignore it, it's unusable.
      s = decodeURIComponent(s.replace(pluses, ' '));
      return config.json ? JSON.parse(s) : s;
    } catch(e) {}
  }

  function read(s, converter) {
    var value = config.raw ? s : parseCookieValue(s);
    return $.isFunction(converter) ? converter(value) : value;
  }

  var config = $.cookie = function (key, value, options) {

    // Write

    if (arguments.length > 1 && !$.isFunction(value)) {
      options = $.extend({}, config.defaults, options);

      if (typeof options.expires === 'number') {
        var days = options.expires, t = options.expires = new Date();
        t.setTime(+t + days * 864e+5);
      }

      return (document.cookie = [
        encode(key), '=', stringifyCookieValue(value),
        options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
        options.path    ? '; path=' + options.path : '',
        options.domain  ? '; domain=' + options.domain : '',
        options.secure  ? '; secure' : ''
      ].join(''));
    }

    // Read

    var result = key ? undefined : {};

    // To prevent the for loop in the first place assign an empty array
    // in case there are no cookies at all. Also prevents odd result when
    // calling $.cookie().
    var cookies = document.cookie ? document.cookie.split('; ') : [];

    for (var i = 0, l = cookies.length; i < l; i++) {
      var parts = cookies[i].split('=');
      var name = decode(parts.shift());
      var cookie = parts.join('=');

      if (key && key === name) {
        // If second argument (value) is a function it's a converter...
        result = read(cookie, value);
        break;
      }

      // Prevent storing a cookie that we couldn't decode.
      if (!key && (cookie = read(cookie)) !== undefined) {
        result[name] = cookie;
      }
    }

    return result;
  };

  config.defaults = {};

  $.removeCookie = function (key, options) {
    if ($.cookie(key) === undefined) {
      return false;
    }

    // Must not alter options, thus extending a fresh object...
    $.cookie(key, '', $.extend({}, options, { expires: -1 }));
    return !$.cookie(key);
  };

}));
