/*
 * Copyright (c) NDS Limited 2008. 
 * All rights reserved. 
 * No part of this program may be reproduced, translated or transmitted, 
 * in any form or by any means, electronic, mechanical, photocopying, 
 * recording or otherwise, or stored in any retrieval system of any nature, 
 * without written permission of the copyright holder. 
 */

/*
 * Created on 11 Dec 2008 by NordJ
 */
package org.example.enforcer;

import java.util.List;
import java.util.Properties;

import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.model.MailingList;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

/**
 * {@link EnforcerRule Enforcer Rule} to check that developers have filled all the details of the POM that we
 * are expecting.
 * 
 * @author James Nord
 */
public class POMCheckRule implements EnforcerRule {

	/* (non-Javadoc)
	 * @see org.apache.maven.enforcer.rule.api.EnforcerRule#execute(org.apache.maven.enforcer.rule.api.EnforcerRuleHelper)
	 */
	public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
		Log log = helper.getLog();

		try {
			// the following results in a bogus pom during some phases
			MavenProject project = (MavenProject) helper.evaluate( "${project}" );
			MavenSession session = (MavenSession) helper.evaluate("${session}");
			MavenProject sessionProject = session.getCurrentProject();

			if (!isBase(project)) {
				log.warn("[POMCheckRule] Rule is executing"); 
				log.warn("[POMCheckRule] ${project} is: " + project); 
				log.warn("[POMCheckRule] ${project}.parent is: " + project.getParent()); 

				log.warn("[POMCheckRule] ${session}.project is: " + sessionProject); 
				log.warn("[POMCheckRule] ${session}.project.parent is: " + sessionProject.getParent());
			}
			else {
				log.warn("[POMCheckRule] Skipping POMCheck rule for base project");
			}			
		}
		catch (ExpressionEvaluationException ex) {
			throw new EnforcerRuleException("[POMCheckRule] Unable to lookup an expression " + ex.getMessage(), ex);
		}
	}



	/* (non-Javadoc)
	 * @see org.apache.maven.enforcer.rule.api.EnforcerRule#getCacheId()
	 */
	public String getCacheId() {
		// TODO Auto-generated method stub
		return null;
	}


	/* (non-Javadoc)
	 * @see org.apache.maven.enforcer.rule.api.EnforcerRule#isCacheable()
	 */
	public boolean isCacheable() {
		// TODO Auto-generated method stub
		return false;
	}


	/* (non-Javadoc)
	 * @see org.apache.maven.enforcer.rule.api.EnforcerRule#isResultValid(org.apache.maven.enforcer.rule.api.EnforcerRule)
	 */
	public boolean isResultValid(EnforcerRule arg0) {
		// TODO Auto-generated method stub
		return false;
	}


	private boolean isBase(MavenProject project) {
		return (project.getGroupId().equals("org.example") && project.getArtifactId().equals("base"));
	}

}
