/**
 *
 *  CONEXANT PROPRIETARY AND CONFIDENTIAL SOFTWARE
 *  Conexant Systems Inc. (c) 2007
 *  Austin, TX
 *  All Rights Reserved
 * 
 *  $Id: AbstractProxyIoHandler.java 2719 2007-09-17 23:34:15Z scott.carter $
 * 
 */

package com.conexant.scm.server;

import java.nio.charset.Charset;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.util.SessionLog;

/**
 * Base class of {@link org.apache.mina.common.IoHandler} classes which handle
 * proxied connections.
 */
public abstract class AbstractProxyIoHandler extends IoHandlerAdapter
{
    private static Charset CHARSET = Charset.forName("iso8859-1");

    /**
     * Generic implementation of sessionCreated() handler for MINA. 
     *  
     * @param session
     */
    @Override
    public void sessionCreated(IoSession session) throws Exception
    {
        session.setTrafficMask(TrafficMask.NONE);
    }

    /**
     * Generic implementation of sessionClosed() handler for MINA. 
     *  
     * @param session
     */
    @Override
    public void sessionClosed(IoSession session) throws Exception 
    {
        if (session.getAttachment() != null)
        {
            SessionLog.debug(session, "*** Session closed");
            ProxySessionState fromProxySessionState = (ProxySessionState) session.getAttachment();
            ProxySessionState toProxySessionState = (ProxySessionState) fromProxySessionState.session.getAttachment();
            SessionLog.debug(session, "fromProxy address = " + fromProxySessionState.session.getRemoteAddress());
            SessionLog.debug(session, "toProxy address = " + toProxySessionState.session.getRemoteAddress());
            toProxySessionState.session.setAttachment(null);
            fromProxySessionState.session.setAttachment(null);
            SessionLog.debug(session, " -- closing toProxy connection");
            toProxySessionState.session.close().join();
            SessionLog.debug(session, " -- closed toProxy");
            SessionLog.debug(session, " -- closing fromProxy connection");
            fromProxySessionState.session.close().join();
            SessionLog.debug(session, " -- closed fromProxy");
            
        }
    }

    /**
     * This abstract method will be overriden in the client-to-proxy 
     * handler to filter messages that are received, in order to 
     * perform the version ID validation function of the SCM Proxy 
     * server. 
     *  
     * @param toProxySessionState
     * @param fromProxySessionState
     * @param message
     * 
     * @return ByteBuffer
     */
    protected abstract ByteBuffer preprocessReceivedMessage(ProxySessionState toProxySessionState, ProxySessionState fromProxySessionState, ByteBuffer message);

    /**
     * Generic implementation of messageReceived() handler for MINA.
     *  
     * @param session
     * @param message
     */
    @Override
    public void messageReceived(IoSession session, Object message) throws Exception
    {
        ProxySessionState toProxySessionState = (ProxySessionState)session.getAttachment();
        ProxySessionState fromProxySessionState = (ProxySessionState)toProxySessionState.session.getAttachment();
        

        ByteBuffer rb = (ByteBuffer) message;
        rb = preprocessReceivedMessage(toProxySessionState, fromProxySessionState, rb);

        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
        rb.mark();
        wb.put(rb);
        wb.flip();
        toProxySessionState.session.write(wb);
        rb.reset();
        SessionLog.debug(session, rb.getString(CHARSET.newDecoder()));
        
        // Release buffers since GC does not seem to collect them
        // rb.release();
        // wb.release();
        
    }
}
