/**
 * 
 * CONEXANT PROPRIETARY AND CONFIDENTIAL SOFTWARE
 * Conexant Systems Inc. (c) 2007
 * Austin, TX
 * All Rights Reserved
 * 
 * 
 * $Id: ScmProxyManager.java 2719 2007-09-17 23:34:15Z scott.carter $
 *
 */

package com.conexant.scm.server;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

public class ScmProxyManager
{
    private enum ProxyManagerCommand
    {
        START,
        STOP,
        RESTART
    }

    private static ProxyManagerCommand command;

    private static void showUsage()
    {
        System.out.println("Usage: java -jar ScmProxyManager.jar <start|stop|restart>");
        System.out.println("");
        System.out.println("   start    Starts the proxy server");
        System.out.println("   stop     Stops the proxy server");
        System.out.println("   restart  Restarts the proxy server");

        System.exit(1);
    }

    private static void parseArgs(String[] args)
    {
        if (args.length != 1)
        {
            showUsage();
        }

        if (args[0].equalsIgnoreCase("start"))
        {
            ScmProxyManager.command = ProxyManagerCommand.START;
        }
        else if (args[0].equalsIgnoreCase("stop"))
        {
            ScmProxyManager.command = ProxyManagerCommand.STOP;
        }
        else if (args[0].equalsIgnoreCase("restart"))
        {
            ScmProxyManager.command = ProxyManagerCommand.RESTART;
        }
    }

    public static void main(String[] args)
    {
        parseArgs(args);

        try
        {
            IProxyManagerService scmProxyServer = (IProxyManagerService)Naming.lookup("rmi://localhost/ScmProxyServer");

            switch (ScmProxyManager.command)
            {
            case START:
                scmProxyServer.startProxyServer();
                break;
            case STOP:
                try
                {
                    scmProxyServer.stopProxyServer(true);
                }
                catch (UnmarshalException ue)
                {
                    // IGNORE - the exception was thrown because the server process
                    //          exits before we can unmarshal its status code.
                }
                break;
            case RESTART:
                scmProxyServer.restartProxyServer();
                break;
            }
        }
        catch (MalformedURLException murle)
        {
            System.err.println("Malformed URL: " + murle.getMessage());
            System.exit(1);
        }
        catch (RemoteException re)
        {
            re.printStackTrace();
            System.exit(1);
        }
        catch (NotBoundException nbe)
        {
            nbe.printStackTrace();
            System.exit(1);
        }

        System.exit(0);
    }
}
