/**
 * 
 * CONEXANT PROPRIETARY AND CONFIDENTIAL SOFTWARE
 * Conexant Systems Inc. (c) 2007
 * Austin, TX
 * All Rights Reserved
 * 
 * 
 * $Id: ServerPropertiesFormatException.java 2719 2007-09-17 23:34:15Z scott.carter $
 *
 */

package com.conexant.scm.server;


/**
 * Exception class wrapper for errors generated during parsing 
 * of SCM Proxy Server properties files. 
 * 
 * @author Sankalp Acharya
 * 
 * @version 
 *
 */
public class ServerPropertiesFormatException extends Exception
{
    public enum ErrorType
    {
        MISSING_KEY ("Missing key entry in properties file"),
        INVALID_VALUE ("Invalid key value"),
        UNKNOWN_HOST ("Unknown host specified in key value"),
        INVALID_VERSION ("Invalid version value");

        private String message;

        ErrorType(String message)
        {
            this.message = message;
        }

        public String getErrorMessage(String keyName)
        {
            return this.message + " for key " + keyName;
        }

        public String getErrorMessage(String keyName, String keyValue)
        {
            return this.message + "'" + keyValue + "'" + " for key " + keyName;
        }
    }

    /**
     * Convenience method for constructing a 
     * ServerPropertiesFormatException based on a specific error 
     * type and the name of a properties key. 
     *  
     * @param errorType
     * @param keyName
     */
    public ServerPropertiesFormatException(ErrorType errorType, String keyName)
    {
        super(errorType.getErrorMessage(keyName));
    }

    public ServerPropertiesFormatException(ErrorType errorType, String keyName, String keyValue)
    {
        super(errorType.getErrorMessage(keyName, keyValue));
    }
}
