/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */  

package org.apache.ftpserver.interfaces;


/**
 * Command factory interface.
 */
public 
interface CommandFactory {

    /**
     * Get the command instance.
     */
    Command getCommand(String commandName);

    /**
     *  Add a command to the command map
     * 
     *  @param cmdName  Name that will be used to call the command from
     *                  the client session [ftp> prompt].
     *  @param cmdClass String containing the class name of the code
     *                  or class that implements the command.
     */
    public void setCommand(String cmdName, String cmdClass);
}
