    #include <stdlib.h>
    #include <clutter/clutter.h>


#define CONTENT_L_X     30
#define CONTENT_L_Y     60
#define CONTENT_L_W     350
#define CONTENT_L_H     400

#define CONTENT_R_X     380
#define CONTENT_R_Y     60
#define CONTENT_R_W     350
#define CONTENT_R_H     400


#define ARROW_L_W       30
#define ARROW_L_H       30
#define ARROW_R_W       30
#define ARROW_R_H       30

#define ARROW_L_X       0
#define ARROW_L_Y       300
#define ARROW_R_X       320
#define ARROW_R_Y       300

    /* 这是我们的一个实验，我们可以不使用Actor的事件侦测，而使用缺省打开的stage的事件，但是我们需要判断根据坐标位置来判断到底发生在哪个 actor上，这样程序会比较繁琐。另外如果我们打开了actor的事件检测，对于某一个事件stage和actor同时又callback函数，则只触发actor的，不触发stage。*/
    static gboolean on_stage_button_press(ClutterStage *stage, ClutterEvent *event,gpointer data){
            gfloat x=0.0 , y =0.0;
            clutter_event_get_coords(event,&x,&y);

            ClutterActor * rect = clutter_stage_get_actor_at_pos (stage,CLUTTER_PICK_ALL,x,y);

            if(!rect){
                    printf("on_stage_button_press trigger -- not on our stage.\n");
                    return FALSE;
            }
            if(rect == data)
                    printf("on_stage_button_press trigger. -- on our rectangle\n");
            else
                    printf("on_stage_button_press trigger. -- other position\n");

        return TRUE;
    }

    static gboolean on_actor_button_press(ClutterRectangle * rect, ClutterEvent *event,gpointer data){
            //ClutterColor actor_color ={0xff,0xff,0xff,0xe0};
            //clutter_rectangle_set_color(rect,&actor_color);
            printf("on_actor_button_press trigger.\n");
            return TRUE;
    }

    static gboolean on_left_arrow_button_release(ClutterActor * actor, ClutterEvent *event,gpointer data){
            //ClutterColor actor_color ={0xff,0xff,0xff,0xA0};
            //clutter_rectangle_set_color(rect,&actor_color);
            printf("on_left_arrow_button_release.\n");
            return TRUE;
    }

    static gboolean on_actor_motion_event(ClutterRectangle * rect, ClutterEvent *event,gpointer data){
            printf("on_actor_motion_event trigger.\n");
            return TRUE;
    }

    static gboolean on_actor_enter_event(ClutterActor * rect, ClutterEvent *event,gpointer data){
            clutter_actor_set_scale(rect,1.2,1.2);
            printf("on_actor_enter_event trigger.\n");
            return TRUE;
    }

    static gboolean on_actor_leave_event(ClutterActor * rect, ClutterEvent *event, gpointer data){
            clutter_actor_set_scale(rect,1.0,1.0);
            printf("on_actor_leave_event trigger.\n");
            return TRUE;
    }

    int main(int argc , char * argv[]){
            ClutterColor stage_color ={0xff,0xff,0xff,0xff};
            ClutterColor actor_color ={0xff,0xff,0xff,0xA0};

            clutter_init(&argc, & argv);

            ClutterActor *stage = clutter_stage_get_default();
            clutter_actor_set_size(stage,800,480);
            clutter_stage_set_color(CLUTTER_STAGE(stage),&stage_color);

    //root container
    ClutterActor    *root_group=clutter_group_new();
    clutter_actor_set_position(root_group, 0, 0);
    clutter_container_add_actor(CLUTTER_CONTAINER(stage),root_group);
    clutter_set_motion_events_enabled (FALSE); /* 实验结果表明：当鼠标进入rect的时候，并没有有效触发enter-event，要按键才能触发，但是鼠标离开rect的时候，也需要按键才能并且触发，但是若鼠标离开stage时，能够触发。*/

    //content container left
    ClutterActor    *actor_content_l=clutter_group_new();
    clutter_actor_set_position(actor_content_l, CONTENT_L_X, CONTENT_L_Y);
    clutter_actor_set_size(actor_content_l, CONTENT_L_W, CONTENT_L_H);
    clutter_container_add_actor(CLUTTER_CONTAINER(root_group), actor_content_l);

    //back image
    ClutterActor *backimg_l=clutter_texture_new_from_file("content_l.jpg", NULL);
    clutter_actor_set_position(backimg_l, 0, 0);
    clutter_container_add_actor(CLUTTER_CONTAINER(actor_content_l), backimg_l);

    //left arrow
    ClutterActor *arrow_l=clutter_texture_new_from_file("left_arrow.png", NULL);
    clutter_actor_set_position(arrow_l, ARROW_L_X, ARROW_L_Y);
    clutter_actor_set_size(arrow_l, ARROW_L_W, ARROW_L_H);
    clutter_container_add_actor(CLUTTER_CONTAINER(actor_content_l), arrow_l);
    clutter_actor_set_reactive (arrow_l, TRUE);
    g_signal_connect (arrow_l, "button-release-event", G_CALLBACK (on_left_arrow_button_release), NULL);

    ClutterActor    *texture_group_l=clutter_texture_new_from_actor(actor_content_l);
    clutter_actor_set_position(texture_group_l, 400, 20);
    clutter_group_add(root_group, texture_group_l);

            clutter_actor_show_all(stage);
            clutter_main();
            return EXIT_SUCCESS;
    }

