#!/bin/bash
#
# Programm zum Anlegen und Entfernen einer Datenbank
# fr OpenTRS innerhalb eines SAPDB Systems
#
# Options:
#     -c create the database
#     -d drop the database

PATH=/opt/sapdb/indep_prog/bin:/opt/sapdb/depend/bin:$PATH
SID=TEST
DBM=dbm,dbm
DBA=dba,dba
DATASIZE=2560
LOGSIZE=1024
OTRS_USER="otrs"
OTRS_PASS="otrs"

if [ "$1" == "-c" ]; then
  # start remote communication server
  echo "start communication server..."
  x_server start >/dev/null 2>&1
 
  # stop and drop probably existing demo database
  echo "stop and drop existing $SID..."
  dbmcli -d $SID -u $DBM db_offline >/dev/null 2>&1
  dbmcli -d $SID -u $DBM db_drop >/dev/null 2>&1

  # create new demo database
  echo "create database $SID..."
  _o=`/opt/sapdb/depend/bin/dbmcli -s -R /opt/sapdb/depend db_create $SID dbm,dbm 2>&1`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "create $SID failed: $_o"
    exit 1
  fi

  # setup database parameters
  echo "set parameters for $SID..."
  _o=`cat <<EOF | dbmcli -d $SID -u $DBM 2>&1
  param_rmfile 
  param_startsession
  param_init OLTP
  param_put LOG_MODE SINGLE
  param_put CAT_CACHE_SUPPLY 300 
  param_put DATA_CACHE 2500
  param_put MAXDATADEVSPACES 5
  param_put MAXDATAPAGES 1024000
  param_checkall
  param_commitsession
  param_adddevspace 1 SYS  DISKS01   F
  param_adddevspace 1 DATA DISKD0001 F $DATASIZE
  param_adddevspace 1 LOG  DISKL001  F $LOGSIZE
  quit 
EOF`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "set parameters failed: $_o"
    exit 1
  fi

  # startup database
  echo "start $SID..."
  _o=`dbmcli -d $SID -u dbm,dbm db_start 2>&1`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "start $SID failed: $_o"
    exit 1
  fi

  # initialize database files
  echo "initializing $SID..."
  _o=`cat <<EOF | dbmcli -d $SID -u $DBM 2>&1
  util_connect dbm,dbm
  util_execute init config
  util_activate $DBA
  quit
EOF`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "initialize $SID failed: $_o"
    exit 1
  fi

  # load database system tables
  echo "load system tables..."
  _o=`dbmcli -d $SID -u $DBM load_systab -u $DBA -ud domain 2>&1`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "load system tables failed: $_o"
    exit 1
  fi

  # create database demo user
  echo "create database OTRS user..."
  _o=`cat <<EOF | dbmcli -d $SID -u $DBA 2>&1
  sql_connect $DBA
  sql_execute CREATE USER $OTRS_USER PASSWORD $OTRS_PASS DBA NOT EXCLUSIVE
EOF`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "create db user failed: $_o"
    exit 1
  fi

  echo "set backup parameters..."
  _o=`cat <<EOF | dbmcli -d $SID -u $DBM 2>&1
  backup_media_put data datasave FILE DATA 0 8 YES
  backup_media_put auto autosave FILE AUTO
  util_connect $DBM
  backup_save data
  autosave_on
  quit
EOF`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "set backup parameters failed: $_o"
    exit 1
  fi

  # OTRS dataload
  repmcli -d $SID -u $DBA -b OpenTRS-schema-create.sql
  repmcli -d $SID -u $DBA -b initial_insert.sql

elif [ "$1" == "-d" ]; then
  # start remote communication server
  x_server start >/dev/null 2>&1 

  echo "stop $SID..."
  _o=`dbmcli -d $SID -u $DBM db_offline 2>&1`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "stop $SID failed: $_o"
  fi

  echo "drop $SID..."
  _o=`/opt/sapdb/depend/bin/dbmcli -s -d $SID -u $DBM db_drop 2>&1`
  _test=`echo $_o | grep OK`
  if [ "$_test" = "" ]; then
    echo "drop $SID failed: $_o"
  fi
fi

