
-- -----------------------------------------------------------------------
-- valid
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('valid') and objectproperty(id, 'isTable') = 1)
DROP TABLE valid;

CREATE TABLE valid
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (50) NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- ticket_priority
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_priority') and objectproperty(id, 'isTable') = 1)
DROP TABLE ticket_priority;

CREATE TABLE ticket_priority
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (50) NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- ticket_lock_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_lock_type') and objectproperty(id, 'isTable') = 1)
DROP TABLE ticket_lock_type;

CREATE TABLE ticket_lock_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (50) NOT NULL,
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- system_user
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('system_user') and objectproperty(id, 'isTable') = 1)
DROP TABLE "system_user";

CREATE TABLE "system_user"
(
    id INTEGER NOT NULL IDENTITY(1,1),
    login VARCHAR (100) NOT NULL,
    pw VARCHAR (50) NOT NULL,
    salutation VARCHAR (50),
    first_name VARCHAR (100) NOT NULL,
    last_name VARCHAR (100) NOT NULL,
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (login)
);

-- -----------------------------------------------------------------------
-- user_preferences
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('user_preferences') and objectproperty(id, 'isTable') = 1)
DROP TABLE user_preferences;

CREATE TABLE user_preferences
(
    user_id INTEGER NOT NULL,
    preferences_key VARCHAR (150) NOT NULL,
    preferences_value VARCHAR (250),

);
CREATE INDEX index_user_preferences_user_id on user_preferences (user_id)
-- -----------------------------------------------------------------------
-- groups
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('groups') and objectproperty(id, 'isTable') = 1)
DROP TABLE groups;

CREATE TABLE groups
(
    id INTEGER NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- group_user
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('group_user') and objectproperty(id, 'isTable') = 1)
DROP TABLE group_user;

CREATE TABLE group_user
(
    user_id INTEGER NOT NULL,
    group_id INTEGER NOT NULL,
    permission_key VARCHAR (20),
    permission_value SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL
);

-- -----------------------------------------------------------------------
-- group_customer_user
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('group_customer_user') and objectproperty(id, 'isTable') = 1)
DROP TABLE group_customer_user;

CREATE TABLE group_customer_user
(
    user_id VARCHAR (40) NOT NULL,
    group_id INTEGER NOT NULL,
    permission_key VARCHAR (20),
    permission_value SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL
);

-- -----------------------------------------------------------------------
-- personal_queues
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('personal_queues') and objectproperty(id, 'isTable') = 1)
DROP TABLE personal_queues;

CREATE TABLE personal_queues
(
    user_id INTEGER NOT NULL,
    queue_id INTEGER NOT NULL
);

-- -----------------------------------------------------------------------
-- theme
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('theme') and objectproperty(id, 'isTable') = 1)
DROP TABLE theme;

CREATE TABLE theme
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    theme VARCHAR (100) NOT NULL,
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (theme)
);

-- -----------------------------------------------------------------------
-- charset
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('charset') and objectproperty(id, 'isTable') = 1)
DROP TABLE charset;

CREATE TABLE charset
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    charset VARCHAR (50) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- ticket_state
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_state') and objectproperty(id, 'isTable') = 1)
DROP TABLE ticket_state;

CREATE TABLE ticket_state
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    comments VARCHAR (250),
    type_id SMALLINT NOT NULL,
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- ticket_state_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_state_type') and objectproperty(id, 'isTable') = 1)
DROP TABLE ticket_state_type;

CREATE TABLE ticket_state_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (120) NOT NULL,
    comments VARCHAR (250),
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- salutation
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('salutation') and objectproperty(id, 'isTable') = 1) DROP TABLE salutation;

CREATE TABLE salutation
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    text VARCHAR (8000) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- signature
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('signature') and objectproperty(id, 'isTable') = 1) DROP TABLE signature;

CREATE TABLE signature
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    text VARCHAR (8000) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- system_address
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('system_address') and objectproperty(id, 'isTable') = 1) DROP TABLE system_address;

CREATE TABLE system_address
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    value0 VARCHAR (200) NOT NULL,
    value1 VARCHAR (200) NOT NULL,
    value2 VARCHAR (200),
    value3 VARCHAR (200),
    queue_id INTEGER NOT NULL,
    comments VARCHAR (200),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id)
);

-- -----------------------------------------------------------------------
-- follow_up_possible
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('follow_up_possible') and objectproperty(id, 'isTable') = 1) DROP TABLE follow_up_possible;

CREATE TABLE follow_up_possible
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    comments VARCHAR (200),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- queue
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('queue') and objectproperty(id, 'isTable') = 1) DROP TABLE queue;

CREATE TABLE queue
(
    id INTEGER NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    group_id INTEGER NOT NULL,
    unlock_timeout INTEGER,
    escalation_time INTEGER,
    system_address_id SMALLINT NOT NULL,
    salutation_id SMALLINT NOT NULL,
    signature_id SMALLINT NOT NULL,
    follow_up_id SMALLINT NOT NULL,
    follow_up_lock SMALLINT NOT NULL,
    move_notify SMALLINT NOT NULL,
    lock_notify SMALLINT NOT NULL,
    state_notify SMALLINT NOT NULL,
    owner_notify SMALLINT NOT NULL,
    comments VARCHAR (200),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- ticket
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket;

CREATE TABLE ticket
(
    id BIGINT NOT NULL IDENTITY(1,1),
    tn VARCHAR (50) NOT NULL,
    queue_id INTEGER NOT NULL,
    ticket_lock_id SMALLINT NOT NULL,
    ticket_answered SMALLINT NOT NULL,
    user_id INTEGER NOT NULL,
    group_id INTEGER NOT NULL,
    ticket_priority_id SMALLINT NOT NULL,
    ticket_state_id SMALLINT NOT NULL,
    group_read SMALLINT,
    group_write SMALLINT,
    other_read SMALLINT,
    other_write SMALLINT,
    customer_id VARCHAR (150),
    customer_user_id VARCHAR (250),
    timeout INTEGER,
    until_time INTEGER,
    freekey1 VARCHAR (80),
    freetext1 VARCHAR (150),
    freekey2 VARCHAR (80),
    freetext2 VARCHAR (150),
    freekey3 VARCHAR (80),
    freetext3 VARCHAR (150),
    freekey4 VARCHAR (80),
    freetext4 VARCHAR (150),
    freekey5 VARCHAR (80),
    freetext5 VARCHAR (150),
    freekey6 VARCHAR (80),
    freetext6 VARCHAR (150),
    freekey7 VARCHAR (80),
    freetext7 VARCHAR (150),
    freekey8 VARCHAR (80),
    freetext8 VARCHAR (150),
    valid_id SMALLINT NOT NULL,
    create_time_unix INTEGER NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (tn),

);
CREATE INDEX index_ticket_queue_view on ticket (ticket_state_id, ticket_lock_id, group_id)
CREATE INDEX index_ticket_user on ticket (user_id)
CREATE INDEX index_ticket_answered on ticket (ticket_answered)

-- -----------------------------------------------------------------------
-- ticket_link
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_link') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_link;

CREATE TABLE ticket_link
(
    ticket_id_master BIGINT NOT NULL,
    ticket_id_slave BIGINT NOT NULL
);

-- -----------------------------------------------------------------------
-- ticket_history
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_history') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_history;

CREATE TABLE ticket_history
(
    id BIGINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    history_type_id SMALLINT NOT NULL,
    ticket_id BIGINT NOT NULL,
    article_id BIGINT,
    system_queue_id SMALLINT,
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),

);
CREATE INDEX ticket_history_ticket_id on ticket_history (ticket_id)
CREATE INDEX ticket_history_create_time on ticket_history (create_time)
-- -----------------------------------------------------------------------
-- ticket_history_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_history_type') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_history_type;

CREATE TABLE ticket_history_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- article_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('article_type') and objectproperty(id, 'isTable') = 1) DROP TABLE article_type;

CREATE TABLE article_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- article_sender_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('article_sender_type') and objectproperty(id, 'isTable') = 1) DROP TABLE article_sender_type;

CREATE TABLE article_sender_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (100) NOT NULL,
    comments VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- article
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('article') and objectproperty(id, 'isTable') = 1) DROP TABLE article;

CREATE TABLE article
(
    id BIGINT NOT NULL IDENTITY(1,1),
    ticket_id INTEGER NOT NULL,
    article_type_id SMALLINT NOT NULL,
    article_sender_type_id SMALLINT NOT NULL,
    a_from VARCHAR (8000),
    a_reply_to VARCHAR (255),
    a_to VARCHAR(8000),
    a_cc VARCHAR(8000),
    a_subject VARCHAR(8000),
    a_message_id VARCHAR (250),
    a_content_type VARCHAR (250),
    a_body VARCHAR (8000) NOT NULL,
    incoming_time INTEGER NOT NULL,
    content_path VARCHAR (250),
    a_freekey1 VARCHAR (250),
    a_freetext1 VARCHAR (250),
    a_freekey2 VARCHAR (250),
    a_freetext2 VARCHAR (250),
    a_freekey3 VARCHAR (250),
    a_freetext3 VARCHAR (250),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),


);
CREATE INDEX article_ticket_id on article (ticket_id)
-- -----------------------------------------------------------------------
-- article_plain
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('article_plain') and objectproperty(id, 'isTable') = 1) DROP TABLE article_plain;

CREATE TABLE article_plain
(
    id BIGINT NOT NULL IDENTITY(1,1),
    article_id BIGINT NOT NULL,
    body VARCHAR (8000),
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),


);
CREATE INDEX article_id on article_plain (article_id)
-- -----------------------------------------------------------------------
-- article_attachment
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('article_attachment') and objectproperty(id, 'isTable') = 1) DROP TABLE article_attachment;

CREATE TABLE article_attachment
(
    id BIGINT NOT NULL IDENTITY(1,1),
    article_id BIGINT NOT NULL,
    filename VARCHAR (250),
    content_type VARCHAR (250),
    content TEXT,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),

);
CREATE INDEX article_id on article_attachment (article_id)
-- -----------------------------------------------------------------------
-- standard_response
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('standard_response') and objectproperty(id, 'isTable') = 1) DROP TABLE standard_response;

CREATE TABLE standard_response
(
    id INTEGER NOT NULL IDENTITY(1,1),
    name VARCHAR (80) NOT NULL,
    text VARCHAR (8000) NOT NULL,
    comments VARCHAR (80),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- queue_standard_response
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('queue_standard_response') and objectproperty(id, 'isTable') = 1) DROP TABLE queue_standard_response;

CREATE TABLE queue_standard_response
(
    queue_id INTEGER NOT NULL,
    standard_response_id INTEGER NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL
);

-- -----------------------------------------------------------------------
-- auto_response_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('auto_response_type') and objectproperty(id, 'isTable') = 1) DROP TABLE auto_response_type;

CREATE TABLE auto_response_type
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (50) NOT NULL,
    comments VARCHAR (80),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- auto_response
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('auto_response') and objectproperty(id, 'isTable') = 1) DROP TABLE auto_response;

CREATE TABLE auto_response
(
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (80) NOT NULL,
    text0 VARCHAR (8000),
    text1 VARCHAR (8000),
    text2 VARCHAR (8000),
    type_id SMALLINT NOT NULL,
    system_address_id SMALLINT NOT NULL,
    charset VARCHAR (80) NOT NULL,
    comments VARCHAR (100),
    valid_id SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- queue_auto_response
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('queue_auto_response') and objectproperty(id, 'isTable') = 1) DROP TABLE queue_auto_response;

CREATE TABLE queue_auto_response
(
    id INTEGER NOT NULL IDENTITY(1,1),
    queue_id INTEGER NOT NULL,
    auto_response_id INTEGER NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id)
);

-- -----------------------------------------------------------------------
-- time_accounting
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('time_accounting') and objectproperty(id, 'isTable') = 1) DROP TABLE time_accounting;

CREATE TABLE time_accounting
(
    id BIGINT NOT NULL IDENTITY(1,1),
    ticket_id BIGINT NOT NULL,
    article_id BIGINT,
    time_unit SMALLINT NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),

);
CREATE INDEX time_accouning_ticket_id on time_accounting (ticket_id)
-- -----------------------------------------------------------------------
-- session
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('session') and objectproperty(id, 'isTable') = 1) DROP TABLE session;

CREATE TABLE session
(
    session_id VARCHAR (120) NOT NULL,
    value VARCHAR (8000) NOT NULL,
    UNIQUE (session_id),

);
CREATE INDEX index_session_id on session (session_id)
-- -----------------------------------------------------------------------
-- ticket_index
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_index') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_index;

CREATE TABLE ticket_index
(
    ticket_id BIGINT NOT NULL,
    queue_id INTEGER NOT NULL,
    queue VARCHAR (70) NOT NULL,
    group_id INTEGER NOT NULL,
    s_lock VARCHAR (70) NOT NULL,
    s_state VARCHAR (70) NOT NULL,
    create_time_unix BIGINT NOT NULL,
);
CREATE INDEX index_ticket_id on ticket_index (ticket_id)
-- -----------------------------------------------------------------------
-- ticket_lock_index
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_lock_index') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_lock_index;

CREATE TABLE ticket_lock_index
(
    ticket_id BIGINT NOT NULL,

);
CREATE INDEX index_lock_ticket_id on ticket_lock_index (ticket_id)
-- -----------------------------------------------------------------------
-- customer_user
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('customer_user') and objectproperty(id, 'isTable') = 1) DROP TABLE customer_user;

CREATE TABLE customer_user
(
    id INTEGER NOT NULL IDENTITY(1,1),
    login VARCHAR (100) NOT NULL,
    email VARCHAR (150) NOT NULL,
    customer_id VARCHAR (200) NOT NULL,
    pw VARCHAR (50) NOT NULL,
    salutation VARCHAR (50),
    first_name VARCHAR (100) NOT NULL,
    last_name VARCHAR (100) NOT NULL,
    valid_id SMALLINT NOT NULL,
    comments VARCHAR (250) NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (login)
);

-- -----------------------------------------------------------------------
-- customer_preferences
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('customer_preferences') and objectproperty(id, 'isTable') = 1) DROP TABLE customer_preferences;

CREATE TABLE customer_preferences
(
    user_id VARCHAR (250) NOT NULL,
    preferences_key VARCHAR (150) NOT NULL,
    preferences_value VARCHAR (250),

);
CREATE INDEX index_customer_preferences_user_id on customer_preferences (user_id)
-- -----------------------------------------------------------------------
-- ticket_loop_protection
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('ticket_loop_protection') and objectproperty(id, 'isTable') = 1) DROP TABLE ticket_loop_protection;

CREATE TABLE ticket_loop_protection
(
    sent_to VARCHAR (250) NOT NULL,
    sent_date VARCHAR (150) NOT NULL,

);
CREATE INDEX index_ticket_loop_protection_sent_to on ticket_loop_protection (sent_to)
CREATE INDEX index_ticket_loop_protection_sent_date on ticket_loop_protection (sent_date)
-- -----------------------------------------------------------------------
-- standard_attachment
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('standard_attachment') and objectproperty(id, 'isTable') = 1) DROP TABLE standard_attachment;

CREATE TABLE standard_attachment
(
    id INTEGER NOT NULL IDENTITY(1,1),
    name varchar (150) NOT NULL,
    content_type varchar (150) NOT NULL,
    content VARCHAR (8000) NOT NULL,
    filename varchar (250) NOT NULL,
    comments varchar (150),
    valid_id smallint NOT NULL,
    create_time DATETIME NOT NULL, 
    create_by integer NOT NULL,
    change_time DATETIME NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);  
-- -----------------------------------------------------------------------
-- standard_response_attachment 
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('standard_response_attachment') and objectproperty(id, 'isTable') = 1) DROP TABLE standard_response_attachment;

CREATE TABLE standard_response_attachment
(   
    id INTEGER NOT NULL IDENTITY(1,1),
    standard_attachment_id integer NOT NULL,
    standard_response_id integer NOT NULL,
    create_time DATETIME NOT NULL,
    create_by integer NOT NULL,
    change_time DATETIME NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);
-- -----------------------------------------------------------------------
-- pop3_account
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('pop3_account') and objectproperty(id, 'isTable') = 1) DROP TABLE pop3_account;

CREATE TABLE pop3_account
(
    id INTEGER NOT NULL IDENTITY(1,1),
    login varchar (200) NOT NULL,
    pw varchar (200) NOT NULL,
    host varchar (200) NOT NULL,
    queue_id integer NOT NULL,
    trusted smallint NOT NULL,
    comments varchar (250),
    valid_id smallint NOT NULL,
    create_time DATETIME NOT NULL,
    create_by integer NOT NULL,
    change_time DATETIME NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-- -----------------------------------------------------------------------
-- search_profile 
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('search_profile') and objectproperty(id, 'isTable') = 1) DROP TABLE search_profile;

CREATE TABLE search_profile
(
    login varchar (200) NOT NULL,
    profile_name varchar (200) NOT NULL,
    profile_key varchar (200) NOT NULL,
    profile_value varchar (200) NOT NULL
);

-- -----------------------------------------------------------------------
-- notifications
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('notifications') and objectproperty(id, 'isTable') = 1) DROP TABLE notifications;

CREATE TABLE notifications
(
    id INTEGER NOT NULL IDENTITY(1,1),
    notification_type varchar (200) NOT NULL,
    notification_charset varchar (60) NOT NULL,
    notification_language varchar (60) NOT NULL,
    subject varchar (250) NOT NULL,
    text VARCHAR (8000) NOT NULL,
    create_time DATETIME NOT NULL,
    create_by integer NOT NULL,
    change_time DATETIME NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-- -----------------------------------------------------------------------
-- faq_item
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_item') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_item;
    
CREATE TABLE faq_item
(   
    id INTEGER NOT NULL IDENTITY(1,1),
    f_name VARCHAR (200) NOT NULL,
    f_language_id SMALLINT NOT NULL,
    f_subject VARCHAR (200),
    state_id SMALLINT NOT NULL,
    category_id SMALLINT NOT NULL,
    f_keywords VARCHAR (8000),
    f_field1 VARCHAR (8000),
    f_field2 VARCHAR (8000),
    f_field3 VARCHAR (8000),
    f_field4 VARCHAR (8000),
    f_field5 VARCHAR (8000),
    f_field6 VARCHAR (8000),
    free_key1 VARCHAR (80),
    free_value1 VARCHAR (200),
    free_key2 VARCHAR (80),
    free_value2 VARCHAR (200),
    free_key3 VARCHAR (80),
    free_value3 VARCHAR (200),
    free_key4 VARCHAR (80),
    free_value4 VARCHAR (200),
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (f_name)
);

-- -----------------------------------------------------------------------
-- faq_language
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_language') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_language;
    
CREATE TABLE faq_language
(   
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- faq_history
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_history') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_history;
    
CREATE TABLE faq_history
(   
    id BIGINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    item_id INTEGER NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id)
);

-- -----------------------------------------------------------------------
-- faq_category
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_category') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_category;
    
CREATE TABLE faq_category
(   
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    comments VARCHAR (220) NOT NULL,
    create_time DATETIME NOT NULL,
    create_by INTEGER NOT NULL,
    change_time DATETIME NOT NULL,
    change_by INTEGER NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- faq_state
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_state') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_state;
    
CREATE TABLE faq_state
(   
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    type_id SMALLINT NOT NULL, 
    PRIMARY KEY(id),
    UNIQUE (name)
);

-- -----------------------------------------------------------------------
-- faq_state_type
-- -----------------------------------------------------------------------
if exists(select * from sysobjects where id = object_id('faq_state_type') and objectproperty(id, 'isTable') = 1) DROP TABLE faq_state_type;
    
CREATE TABLE faq_state_type
(   
    id SMALLINT NOT NULL IDENTITY(1,1),
    name VARCHAR (200) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

