


-----------------------------------------------------------------------------
-- valid
-----------------------------------------------------------------------------
CREATE TABLE valid
(
    id numeric(11),
    name varchar (50) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_priority
-----------------------------------------------------------------------------
CREATE TABLE ticket_priority
(
    id numeric(11),
    name varchar (50) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_lock_type
-----------------------------------------------------------------------------
CREATE TABLE ticket_lock_type
(
    id numeric(11),
    name varchar (50) NOT NULL,
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- system_user
-----------------------------------------------------------------------------
CREATE TABLE system_user
(
    id numeric(11),
    login varchar (100) NOT NULL,
    pw varchar (500) NOT NULL,
    salutation varchar (50),
    first_name varchar (100) NOT NULL,
    last_name varchar (100) NOT NULL,
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (login)
);

-----------------------------------------------------------------------------
-- user_preferences
-----------------------------------------------------------------------------
CREATE TABLE user_preferences
(
    user_id numeric(11) NOT NULL,
    preferences_key varchar (150) NOT NULL,
    preferences_value varchar (250)
);
create  INDEX I_user_id ON user_preferences (user_id);

-----------------------------------------------------------------------------
-- groups
-----------------------------------------------------------------------------
CREATE TABLE groups
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- group_user
-----------------------------------------------------------------------------
CREATE TABLE group_user
(
    user_id numeric(11) NOT NULL,
    group_id numeric(11) NOT NULL,
    permission_key VARCHAR (20),
    permission_value numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL
);

-----------------------------------------------------------------------------
-- group_customer_user
-----------------------------------------------------------------------------
CREATE TABLE group_customer_user
(
    user_id VARCHAR (40) NOT NULL,
    group_id numeric(11) NOT NULL,
    permission_key VARCHAR (20),
    permission_value numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL
);

-----------------------------------------------------------------------------
-- personal_queues
-----------------------------------------------------------------------------
CREATE TABLE personal_queues
(
    user_id numeric(11) NOT NULL,
    queue_id numeric(11) NOT NULL
);

-----------------------------------------------------------------------------
-- theme
-----------------------------------------------------------------------------
CREATE TABLE theme
(
    id numeric(11),
    theme varchar (100) NOT NULL,
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (theme)
);

-----------------------------------------------------------------------------
-- charset
-----------------------------------------------------------------------------
CREATE TABLE charset
(
    id numeric(11),
    name varchar (200) NOT NULL,
    charset varchar (50) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_state
-----------------------------------------------------------------------------
CREATE TABLE ticket_state
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    type_id numeric(6) NOT NULL,
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_state_type
-----------------------------------------------------------------------------
CREATE TABLE ticket_state_type
(
    id numeric(11),
    name VARCHAR (120) NOT NULL,
    comments VARCHAR (250),
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- salutation
-----------------------------------------------------------------------------
CREATE TABLE salutation
(
    id numeric(11),
    name varchar (100) NOT NULL,
    text VARCHAR2(4000) not null,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- signature
-----------------------------------------------------------------------------
CREATE TABLE signature
(
    id numeric(11),
    name varchar (100) NOT NULL,
    text VARCHAR2(4000) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- system_address
-----------------------------------------------------------------------------
CREATE TABLE system_address
(
    id numeric(11),
    value0 varchar (200) NOT NULL,
    value1 varchar (200) NOT NULL,
    value2 varchar (200), 
    value3 varchar (200),
    queue_id numeric(6) NOT NULL,
    comments varchar (200),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- follow_up_possible
-----------------------------------------------------------------------------
CREATE TABLE follow_up_possible
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue
-----------------------------------------------------------------------------
CREATE TABLE queue
(
    id numeric(11),
    name varchar (200) NOT NULL,
    group_id numeric(6) NOT NULL,
    unlock_timeout numeric(11),
    escalation_time numeric(11),
    system_address_id numeric(6) NOT NULL,
    salutation_id numeric(6) NOT NULL,
    signature_id numeric(6) NOT NULL,
    follow_up_id numeric(6) NOT NULL,
    follow_up_lock numeric(6) NOT NULL,
    move_notify numeric(6) NOT NULL,
    lock_notify numeric(6) NOT NULL,
    state_notify numeric(6) NOT NULL,
    owner_notify numeric(6) NOT NULL,
    comments varchar (200),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket
-----------------------------------------------------------------------------
CREATE TABLE ticket
(
    id numeric(11),
    tn varchar (50) NOT NULL,
    queue_id numeric(11) NOT NULL,
    ticket_lock_id numeric(6) NOT NULL,
    ticket_answered numeric(6) NOT NULL,
    user_id numeric(11) NOT NULL,
    group_id numeric(11) NOT NULL,
    ticket_priority_id numeric(6) NOT NULL,
    ticket_state_id numeric(6) NOT NULL,
    group_read numeric(6),
    group_write numeric(6),
    other_read numeric(6),
    other_write numeric(6),
    customer_id varchar (150),
    customer_user_id varchar (250),
    timeout numeric(11),
    until_time numeric(11),
    freekey1 varchar (80),
    freetext1 varchar (150),
    freekey2 varchar (80),
    freetext2 varchar (150),
    freekey3 varchar (80),
    freetext3 varchar (150),
    freekey4 varchar (80),
    freetext4 varchar (150),
    freekey5 varchar (80),
    freetext5 varchar (150),
    freekey6 varchar (80),
    freetext6 varchar (150),
    freekey7 varchar (80),
    freetext7 varchar (150),
    freekey8 varchar (80),
    freetext8 varchar (150),
    valid_id numeric(6) NOT NULL,
    create_time_unix numeric(11) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (tn)
);
create  INDEX I_ticket_queue_view ON ticket (ticket_state_id, ticket_lock_id, group_id);
create  INDEX I_ticket_user ON ticket (user_id);
create  INDEX I_ticket_answered ON ticket (ticket_answered);

-----------------------------------------------------------------------------
-- ticket_link
-----------------------------------------------------------------------------
CREATE TABLE ticket_link
(
    ticket_id_master numeric(11) NOT NULL,
    ticket_id_slave numeric(11) NOT NULL
);

-----------------------------------------------------------------------------
-- ticket_history
-----------------------------------------------------------------------------
CREATE TABLE ticket_history
(
    id numeric(11),
    name varchar (200) NOT NULL,
    history_type_id numeric(6) NOT NULL,
    ticket_id numeric(22) NOT NULL,
    article_id numeric(22),
    system_queue_id numeric(6),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);
create  INDEX ticket_history_ticket_id ON ticket_history (ticket_id);
create  INDEX ticket_history_create_time ON ticket_history (create_time);

-----------------------------------------------------------------------------
-- ticket_history_type
-----------------------------------------------------------------------------
CREATE TABLE ticket_history_type
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article_type
-----------------------------------------------------------------------------
CREATE TABLE article_type
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article_sender_type
-----------------------------------------------------------------------------
CREATE TABLE article_sender_type
(
    id numeric(11),
    name varchar (100) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article
-----------------------------------------------------------------------------
CREATE TABLE article
(
    id numeric(11),
    ticket_id numeric(22) NOT NULL,
    article_type_id numeric(6) NOT NULL,
    article_sender_type_id numeric(6) NOT NULL,
    a_from varchar2(4000),
    a_reply_to varchar2 (4000),
    a_to varchar2(4000),
    a_cc varchar2(4000),
    a_subject varchar2(4000),
    a_message_id varchar (250),
    a_content_type varchar (250),
    a_body CLOB NOT NULL,
    incoming_time numeric(11) NOT NULL,
    content_path varchar (250),
    a_freekey1 varchar (250),
    a_freetext1 varchar (250),
    a_freekey2 varchar (250),
    a_freetext2 varchar (250),
    a_freekey3 varchar (250),
    a_freetext3 varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    a_body_short VARCHAR2(4000),
    PRIMARY KEY(id)
);
create INDEX I_article_ticket_id ON article (ticket_id);
create INDEX I_article_from_id ON article (a_from);
create INDEX I_article_body ON article (a_body_short);
-----------------------------------------------------------------------------
-- article_attachment
-----------------------------------------------------------------------------
CREATE TABLE article_attachment
(
    id numeric(11),
    article_id numeric(22) NOT NULL,
    filename VARCHAR (250),
    content_type VARCHAR (250),
    content CLOB,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);
create INDEX I_article_attach_article_id ON article_attachment (article_id);

-----------------------------------------------------------------------------
-- article_plain
-----------------------------------------------------------------------------
CREATE TABLE article_plain
(
    id numeric(11),
    article_id numeric(22) NOT NULL,
    body CLOB,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);
create INDEX I_article_plain_article_id ON article_plain (article_id);


-----------------------------------------------------------------------------
-- standard_response
-----------------------------------------------------------------------------
CREATE TABLE standard_response
(
    id numeric(11),
    name varchar (80) NOT NULL,
    text VARCHAR2(4000),
    comments varchar (80),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue_standard_response
-----------------------------------------------------------------------------
CREATE TABLE queue_standard_response
(
    queue_id numeric(11) NOT NULL,
    standard_response_id numeric(11) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL
);

-----------------------------------------------------------------------------
-- standard_attachment
-----------------------------------------------------------------------------
CREATE TABLE standard_attachment
(
    id numeric(11),
    name varchar (150) NOT NULL,
    content_type varchar (150) NOT NULL,
    content CLOB NOT NULL,
    filename varchar (250) NOT NULL,
    comments varchar (150),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- standard_response_attachment
-----------------------------------------------------------------------------
CREATE TABLE standard_response_attachment 
(
    id numeric(11),
    standard_attachment_id numeric(11) NOT NULL,
    standard_response_id numeric(11) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- auto_response_type
-----------------------------------------------------------------------------
CREATE TABLE auto_response_type
(
    id numeric(11),
    name varchar (50) NOT NULL,
    comments varchar (80),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- auto_response
-----------------------------------------------------------------------------
CREATE TABLE auto_response
(
    id numeric(11),
    name varchar (80) NOT NULL,
    text0 VARCHAR2(4000),
    text1 VARCHAR2(4000),
    text2 VARCHAR2(4000),
    type_id numeric(6) NOT NULL,
    system_address_id numeric(6) NOT NULL,
    charset varchar (80) NOT NULL,
    comments varchar (100),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue_auto_response
-----------------------------------------------------------------------------
CREATE TABLE queue_auto_response
(
    id numeric(11),
    queue_id numeric(11) NOT NULL,
    auto_response_id numeric(11) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);

----------------------------------------------------------------------------
-- time_accounting
-----------------------------------------------------------------------------
CREATE TABLE time_accounting
(
    id numeric(11),
    ticket_id numeric(22) NOT NULL,
    article_id numeric(22),
    time_unit numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);
create  INDEX time_accounting_ticket_id ON time_accounting (ticket_id);

-----------------------------------------------------------------------------
-- sessiondb
-----------------------------------------------------------------------------
CREATE TABLE sessiondb
(
    session_id varchar (120) NOT NULL,
    value VARCHAR2(4000) NOT NULL,
    UNIQUE (session_id)
);

-----------------------------------------------------------------------------
-- ticket_index
-----------------------------------------------------------------------------
CREATE TABLE ticket_index
(
    ticket_id numeric(22) NOT NULL,
    queue_id numeric(11) NOT NULL,
    queue varchar (70) NOT NULL,
    group_id numeric(11) NOT NULL,
    s_lock varchar (70) NOT NULL,
    s_state varchar (70) NOT NULL,
    create_time_unix numeric(22) NOT NULL
);
create  INDEX I_ticket_id ON ticket_index (ticket_id);

-----------------------------------------------------------------------------
-- ticket_lock_index
-----------------------------------------------------------------------------
CREATE TABLE ticket_lock_index
(
    ticket_id numeric(22) NOT NULL
);
create  INDEX I_lock_ticket_id ON ticket_lock_index (ticket_id);

-----------------------------------------------------------------------------
-- customer_user
-----------------------------------------------------------------------------
CREATE TABLE customer_user
(
    id numeric(11),
    login varchar (100) NOT NULL,
    email varchar (150) NOT NULL,
    customer_id VARCHAR (200) NOT NULL,
    pw varchar (50) NOT NULL,
    salutation varchar (50),
    first_name varchar (100) NOT NULL,
    last_name varchar (100) NOT NULL,
    comments varchar (250) NOT NULL,
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (login)
);

-----------------------------------------------------------------------------
-- customer_preferences
-----------------------------------------------------------------------------
CREATE TABLE customer_preferences
(
    user_id varchar (250) NOT NULL,
    preferences_key varchar (150) NOT NULL,
    preferences_value varchar (250)
);
create INDEX I_cuser_id ON customer_preferences (user_id);

-----------------------------------------------------------------------------
-- ticket_loop_protection
-----------------------------------------------------------------------------
CREATE TABLE ticket_loop_protection
(
    sent_to VARCHAR (250) NOT NULL,
    sent_date VARCHAR (150) NOT NULL
);
CREATE INDEX I_ticket_loop_protection_to ON ticket_loop_protection (sent_to);
CREATE INDEX I_ticket_loop_protection_da ON ticket_loop_protection (sent_date);

-----------------------------------------------------------------------------
-- pop3_account
-----------------------------------------------------------------------------
CREATE TABLE pop3_account
(
    id numeric(11),
    login varchar (200) NOT NULL,
    pw varchar (200) NOT NULL,
    host varchar (200) NOT NULL,
    queue_id numeric(11) NOT NULL,
    trusted numeric(6) NOT NULL,
    comments varchar (250),
    valid_id numeric(6) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- search_profile
-----------------------------------------------------------------------------
CREATE TABLE search_profile
(
    login varchar (200) NOT NULL,
    profile_name varchar (200) NOT NULL,
    profile_key varchar (200) NOT NULL,
    profile_value varchar (200) NOT NULL
);

-----------------------------------------------------------------------------
-- notifications
-----------------------------------------------------------------------------
CREATE TABLE notifications
(   
    id numeric(11),
    notification_type varchar (200) NOT NULL,
    notification_charset varchar (60) NOT NULL,
    notification_language varchar (60) NOT NULL,
    subject varchar (250) NOT NULL,
    text VARCHAR2(4000) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);  

-----------------------------------------------------------------------------
-- faq_item 
-----------------------------------------------------------------------------
CREATE TABLE faq_item
(
    id numeric(11), 
    f_name VARCHAR (200) NOT NULL,
    f_language_id numeric(6) NOT NULL,
    f_subject VARCHAR (200),
    state_id numeric(6) NOT NULL,
    category_id numeric(6) NOT NULL,
    f_keywords VARCHAR2(4000),
    f_field1 VARCHAR2(4000),
    f_field2 VARCHAR2(4000),
    f_field3 VARCHAR2(4000),
    f_field4 VARCHAR2(4000),
    f_field5 VARCHAR2(4000),
    f_field6 VARCHAR2(4000),
    free_key1 VARCHAR (80),
    free_value1 VARCHAR (200),
    free_key2 VARCHAR (80),
    free_value2 VARCHAR (200),
    free_key3 VARCHAR (80),
    free_value3 VARCHAR (200),
    free_key4 VARCHAR (80),
    free_value4 VARCHAR (200),
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (f_name)
);

-----------------------------------------------------------------------------
-- faq_language
-----------------------------------------------------------------------------
CREATE TABLE faq_language
(
    id numeric(11), 
    name VARCHAR (200) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- faq_history
-----------------------------------------------------------------------------
CREATE TABLE faq_history
(
    id numeric(11),
    name VARCHAR (200) NOT NULL,
    item_id numeric(11) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- faq_category
-----------------------------------------------------------------------------
CREATE TABLE faq_category
(
    id numeric(11),
    name VARCHAR (200) NOT NULL,
    comments VARCHAR (220) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by numeric(11) NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- faq_state
-----------------------------------------------------------------------------
CREATE TABLE faq_state
(
    id numeric(11),
    name VARCHAR (200) NOT NULL,
    type_id numeric(11) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- faq_state_type
-----------------------------------------------------------------------------
CREATE TABLE faq_state_type
(
    id numeric(11),
    name VARCHAR (200) NOT NULL,
    PRIMARY KEY(id), 
    UNIQUE (name)
);  

---
-- Trigger zur Nachbildung von Auto increment
---

DROP SEQUENCE auto_increment_id ;
DROP SEQUENCE auto_increment_t_priority_id ;
DROP SEQUENCE auto_increment_t_lock_id ;
DROP SEQUENCE auto_increment_s_user_id ;
DROP SEQUENCE auto_increment_charset_id ;
DROP SEQUENCE auto_increment_t_state_id ;
DROP SEQUENCE auto_increment_ts_type_id ;
DROP SEQUENCE auto_increment_sal_id ;
DROP SEQUENCE auto_increment_sig_id ;
DROP SEQUENCE auto_increment_sysad_id ;
DROP SEQUENCE auto_increment_fup_p_id ;
DROP SEQUENCE auto_increment_queue_id ;
DROP SEQUENCE auto_increment_ticket_id ;
DROP SEQUENCE auto_increment_t_history_id ;
DROP SEQUENCE auto_increment_t_h_type_id ;
DROP SEQUENCE auto_increment_a_type_id ;
DROP SEQUENCE auto_increment_a_s_type_id ;
DROP SEQUENCE auto_increment_article_id ;
DROP SEQUENCE auto_increment_a_plain_id ;
DROP SEQUENCE auto_increment_a_attach_id ;
DROP SEQUENCE auto_increment_s_resp_id ;
DROP SEQUENCE auto_increment_a_r_type_id ;
DROP SEQUENCE auto_increment_a_resp_id ;
DROP SEQUENCE auto_increment_q_a_resp_id ;
DROP SEQUENCE auto_increment_t_acct_id ;
DROP SEQUENCE auto_increment_c_user_id ;
DROP SEQUENCE auto_increment_s_attach_id ;
DROP SEQUENCE auto_increment_s_r_attach_id ;
DROP SEQUENCE auto_increment_pop3_acct_id ;
DROP SEQUENCE auto_increment_notif_id ;
DROP SEQUENCE auto_increment_f_item_id ;
DROP SEQUENCE auto_increment_f_lang_id ;
DROP SEQUENCE auto_increment_f_hist_id ;
DROP SEQUENCE auto_increment_f_cat_id ;
DROP SEQUENCE auto_increment_f_state_id ;
DROP SEQUENCE auto_increment_f_s_type_id ;
DROP SEQUENCE auto_increment_theme_id ;
DROP SEQUENCE auto_increment_groups_id ;

CREATE SEQUENCE auto_increment_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_priority_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_lock_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_s_user_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_charset_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_state_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_ts_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_sal_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_sig_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_sysad_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_fup_p_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_queue_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_ticket_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_history_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_h_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_s_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_article_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_plain_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_attach_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_s_resp_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_r_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_a_resp_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_q_a_resp_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_t_acct_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_c_user_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_s_attach_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_s_r_attach_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_pop3_acct_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_notif_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_item_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_lang_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_hist_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_cat_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_state_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_f_s_type_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_theme_id INCREMENT BY 1 START WITH 1 CACHE 2;
CREATE SEQUENCE auto_increment_groups_id INCREMENT BY 1 START WITH 1 CACHE 2;

CREATE OR REPLACE TRIGGER T_increment_valid_id BEFORE INSERT on valid
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_priority_id BEFORE INSERT on ticket_priority
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_priority_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_lock_id BEFORE INSERT on ticket_lock_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_lock_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_s_user_id BEFORE INSERT on system_user
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_s_user_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_charset_id BEFORE INSERT on charset
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_charset_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_state_id BEFORE INSERT on ticket_state
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_state_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_ts_type_id BEFORE INSERT on ticket_state_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_ts_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_sal_id BEFORE INSERT on salutation
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_sal_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_sig_id BEFORE INSERT on signature
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_sig_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_sysad_id BEFORE INSERT on system_address
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_sysad_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_fup_p_id BEFORE INSERT on follow_up_possible
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_fup_p_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_queue_id BEFORE INSERT on queue
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_queue_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_ticket_id BEFORE INSERT on ticket
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_ticket_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_history_id BEFORE INSERT on ticket_history
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_history_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_h_type_id BEFORE INSERT on ticket_history_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_h_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_type_id BEFORE INSERT on article_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_s_type_id BEFORE INSERT on article_sender_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_s_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_article_id BEFORE INSERT on article
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_article_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_plain_id BEFORE INSERT on article_plain
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_plain_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_attach_id BEFORE INSERT on article_attachment
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_attach_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_s_resp_id BEFORE INSERT on standard_response
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_s_resp_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_r_type_id BEFORE INSERT on auto_response_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_r_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_a_resp_id BEFORE INSERT on auto_response
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_a_resp_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_q_a_resp_id BEFORE INSERT on queue_auto_response
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_q_a_resp_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_t_acct_id BEFORE INSERT on time_accounting
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_t_acct_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_c_user_id BEFORE INSERT on customer_user
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_c_user_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_s_attach_id BEFORE INSERT on standard_attachment
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_s_attach_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_s_r_attach_id BEFORE INSERT on standard_response_attachment
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_s_r_attach_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_pop3_acct_id BEFORE INSERT on pop3_account
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_pop3_acct_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_notif_id BEFORE INSERT on notifications
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_notif_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_item_id BEFORE INSERT on faq_item
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_item_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_lang_id BEFORE INSERT on faq_language
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_lang_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_hist_id BEFORE INSERT on faq_history
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_hist_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_cat_id BEFORE INSERT on faq_category
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_cat_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_state_id BEFORE INSERT on faq_state
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_state_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_f_s_type_id BEFORE INSERT on faq_state_type
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_f_s_type_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_theme_id BEFORE INSERT on theme
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_theme_id.nextval into :NEW.id FROM DUAL;
        END;
/
CREATE OR REPLACE TRIGGER T_increment_groups_id BEFORE INSERT on groups
        REFERENCING NEW AS NEW OLD AS OLD FOR EACH ROW
        WHEN (NEW.id is null) 
        Begin
          SELECT auto_increment_groups_id.nextval into :NEW.id FROM DUAL;
        END;
/
