#
# Maibaum 06.07.04
#

package Kernel::System::FAQ::ArticleStorageFS;

use strict;
use File::Path;
use File::Basename;
use MIME::Words qw(:all);

# --
# to get it writable for the otrs group (just in case)
# --
umask 002;

use vars qw($VERSION);
$VERSION = '$Revision: 1.11 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub WriteFAQAttachment {
    my $Self = shift;
    my %Param = @_;
    # check needed stuff
    foreach (qw(Content Filename FAQID)) {
      if (!$Param{$_}) {
        $Self->{LogObject}->Log(Priority => 'error', Message => "Need $_!");
        return;
      }
    }
    my $FAQPath = $Self->{ConfigObject}->Get('FAQDirectory');

    # define path
    $Param{Path} = $FAQPath.$Param{FAQID};
    # check used name (we want just uniq names)
    my $NewFileName = decode_mimewords($Param{Filename});
    $Param{Filename} = $NewFileName;
    #  create directory if necessary         
    if (! -d $Param{Path}) {
        if (! File::Path::mkpath([$Param{Path}], 0, 0775)) {
            $Self->{LogObject}->Log(Priority => 'error', Message => "Can't create $Param{Path}: $!");
            return;
        }
    }
    # write attachment to fs
    if (open (DATA, "> $Param{Path}/$Param{Filename}")) {
        print DATA $Param{Content};
        close (DATA);
        return 1;
    }
    else {
        $Self->{LogObject}->Log(
            Priority => 'error', 
            Message => "Can't write: $Param{Path}/$Param{Filename}: $!",
        );
        return;
    }
}

sub DeleteAttachmentFile{
    my $Self = shift;
    my %Param = @_;
    # check needed stuff
    foreach (qw(FAQID Filename)) {
      if (!$Param{$_}) {
        $Self->{LogObject}->Log(Priority => 'error', Message => "Need $_!");
        return;
      }
    }
    my $FILENAME = $Self->{ConfigObject}->Get('FAQDirectory') . $Param{FAQID} . "/" . $Param{Filename};
    if (unlink($FILENAME)){ 
	return 1;
    }else{
        $Self->{LogObject}->Log(
            Priority => 'error',
            Message => "Can't delete: $FILENAME: $!",
        );
	return;
    }
}

sub DeleteAttachmentFiles{
    my $Self = shift;
    my %Param = @_;
    # check needed stuff
    foreach (qw(FAQID)) {
      if (!$Param{$_}) {
        $Self->{LogObject}->Log(Priority => 'error', Message => "Need $_!");
        return;
      }
    }
    if ($Self->{ConfigObject}->Get('FAQDirectory') && $Param{FAQID}){
    	my $DIRNAME = $Self->{ConfigObject}->Get('FAQDirectory') . $Param{FAQID};
	system ("rm -rf $DIRNAME") or return;
	return 1;
    }
    return;
}


sub GetAttachmentFiles {
    my $Self = shift;
    my %Param = @_;
    # check needed stuff
    foreach (qw(FAQID)) {
      if (!$Param{$_}) {
        $Self->{LogObject}->Log(Priority => 'error', Message => "Need $_!");
        return;
      }
    }
    my $FAQPath = $Self->{ConfigObject}->Get('FAQDirectory') . $Param{FAQID} . "/";

    opendir(DIRECTORY1, $FAQPath) or return;
    my @urls;
    # put filenames in array
    while( defined (my $file = readdir DIRECTORY1) ) {
       # do not show the "." and ".." file 
       if ($file !~ m/^(\.|\.\.)$/){
            push (@urls, $file);
       }
    }
    closedir(DIRECTORY1);
    return @urls;	 	   	
}
# --

1;
