# --
# DDlib.pm - Damir's goodies library.
# --
# $Id: $
# --
# This software comes with ABSOLUTELY NO WARRANTY. See LGPL.
# --

package DDlib;

use strict;
use MIME::Words qw(:all);
use MIME::Entity;
use Mail::Address;
use Encode;

BEGIN {
  use Exporter ();
  use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
  @ISA = qw(Exporter);
  @EXPORT = qw();
  @EXPORT_OK = qw(safe_encode strlim nice_size parse_varlist dequote);
  %EXPORT_TAGS = qw();
}

use vars qw($VERSION);
$VERSION = '$Revision: 1.6.2.1 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

=head1 NAME

DDlib - Damir's goodies library

=head1 SYNOPSIS

Global module to do various data/format conversions and such.

=cut

#
sub safe_encode {
  my ($str) = @_;

  # recognize which encoding could be used (TODO)
  if ($str =~ /[\x7F-\xFF\x{0100}-\x{0200}]/) {
    $str = conv_to_l2($str);
  }
  $str =~ s/[\x{0100}-\x{EFFF}]/?/g;
  return $str;
}

# convert internal wide character to 8-bit ISO-8859-2 code
#
sub conv_to_l2 {
  my ($old) = @_;

  my ($str) = $old;

  if ($str =~ /[\x{0100}-\x{0200}]/) {
    # encode internal wide characters as l2
    $str = Encode::encode('iso-8859-2', $str);
  }
  elsif ($str =~ /[\xC2-\xC5][\x80-\xFE]/) {
    # convert from utf-8 to l2
    Encode::from_to($str, 'utf-8', 'iso-8859-2');
  }
  $str = latin2_filter($str);
  return $str;
}

# filter out latin2 characters
# (replace them with plain letter)
#
sub latin2_filter {
  my ($str) = @_;
  $str =~ y/\xC8\xE8\xC6\xE6\xD0\xF0\xA9\xB9\xAE\xBE\x8A\x9A\x8E\x9E/CcCcDdSsZzSsZz/;
  return $str;
}

# limit string length
sub strlim {
  my ($str, $lim) = @_;
  return ((length($str) > $lim) ? substr($str, 0, $lim) : $str);
}
sub nice_size {
  my ($b) = @_;
  if ($b > 10_000_000) {
    return '****';
  }
  elsif ($b > 1_000_000) {
    return sprintf("%3.2fM", $b / 1_000_000);
  }
  elsif ($b > 1_000) {
    return sprintf("%3dK", int($b / 1_000));
  }
  else {
    return sprintf("%3dB", $b);
  }
}

#
# --
# parse assignment list with space-separated values
# with optional double quotes around value-strings
sub parse_varlist {
  my ($str) = @_;
  my @ret = ();
  return @ret unless $str;
  while ($str =~ /\G\s*(?!\$)([-\w]+)=(\"((?:\\\")|[^\"])*\"|[^,\s\"]*)(?:,\s|\s)?/g) {
    my ($k, $v) = ($1, $2);
    $v =~ s/\s+$//;
    $v = dequote ($v);
    $k =~ y/-/_/;
    $k = lc($k);
    push(@ret, lc($k), $v);
  }
  # print STDERR join('!', @ret), "\n";
  return @ret;
}
sub dequote {
  my ($v) = @_;
  if ($v =~ s/^\'//) {
    chop($v);
    $v =~ s/\\\'/\'/g;
  } elsif ($v =~ s/^\"//) {
    chop($v);
    $v =~ s/\\\"/\"/g;
  }
  return $v;
}

1;

=cut

=head1 VERSION

$Revision: $

=cut

