use warnings;
use strict;

use Apache2;
use Apache::ServerUtil ();
use Apache::Server ();

use File::Spec::Functions qw(catdir);

# base server
my $s = Apache->server;

my $vhost_doc_root = catdir Apache::Server::server_root, qw(htdocs vhost);

# testing $s->add_config() in vhost
my $conf = <<"EOC";
# must use PerlModule here to check for segfaults
# (even though it's not required)
PerlModule TestVhost::basic
PerlSetVar DocumentRootCheck $vhost_doc_root
<Location /TestVhost__basic>
    SetHandler modperl
    PerlResponseHandler TestVhost::basic
</Location>
EOC

$s->add_config([split /\n/, $conf]);

# this used to have problems on win32
$s->add_config(['<Perl >', '1;', '</Perl>']);

1;

