package PrintEnv;

require 5.005;
use strict;

use vars qw($VERSION);
$VERSION = '0.1';

use mod_perl;
use constant MP2 => ($mod_perl::VERSION >= 1.99);

BEGIN {
	# Test mod_perl version and use the appropriate components
	if (MP2) {
		require Apache::Const;
		Apache::Const->import(-compile => qw(OK));
		require Apache::RequestRec;
		require Apache::RequestIO;
	}
	else {
		require Apache::Constants;
		Apache::Constants->import(qw(OK));
	}
}

sub handler {
	my $r = shift;
	my $str;
	foreach (sort keys %ENV) {
		$str .= "$_ = $ENV{$_}\n";
	}
	$str .= "\n\n";
	foreach (sort keys %{$r->subprocess_env}) {
		$str .= "$_ = " . $r->subprocess_env->{$_} . "\n";
	}
	$str .= "\n\n";
	foreach (sort keys %{$r->headers_in()}) {
		$str .= "$_ = " . $r->headers_in->{$_} . "\n";
	}
	$str .= $r->pnotes('SUBPROCESS_ENV_TEST');
   # Output code to client
   $r->content_type('text/plain'); 
   MP2 ? 1 : $r->send_http_header;
   $r->print($str);
   return MP2 ? Apache::OK : Apache::Constants::OK;
}

1;
