package SubProcessEnvTest;

require 5.005;
use strict;

use vars qw($VERSION);
$VERSION = '1.00';

use mod_perl;
use constant MP2 => ($mod_perl::VERSION >= 1.99);

# Test libapreq modules
my $libapreq;
BEGIN {
	# Test mod_perl versione and use the appropriate components
	if (MP2) {
		require Apache::Const;
		Apache::Const->import(-compile => qw(DECLINED));
		require Apache::RequestRec;
		require Apache::RequestUtil;
	}
	else {
		require Apache::Constants;
		Apache::Constants->import(qw(DECLINED));
	}
}

sub handler {
	my $r = shift;
	
	# Populate env table, headers in table and pnotes
	$r->subprocess_env('SUBPROCESS_ENV_TEST' => time);
	$r->pnotes('SUBPROCESS_ENV_TEST' => time );
	$r->headers_in->{'X-SUBPROCESS_ENV_TEST'} = time;
	return (MP2 ? Apache::DECLINED : Apache::Constants::DECLINED);
}

1;
