use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

my $defines = Apache::Test::vars('defines');
my $ok;

if ($defines =~ m/Mix/) {
  $ok++
}

plan tests => 1, (have_lwp && $ok);

my $uri = "/index.html?$defines";

t_debug("uri: $uri");

my $response = GET $uri;

my $received = $response->content;

# our C handlers hook FIRST, so the following is expected
#
#  PerlHookPostReadRequestHandler ReallyLast  (C, Perl)
#  PerlHookTransHandler           ReallyFirst (Perl, C)
#  PerlHookMapToStorageHandler    ReallyFirst (Perl, C)
#  PerlHookHeaderParserHandler    Last        (C, Perl)
#  PerlHookAccessHandler          Middle      (C, Perl)
#  PerlHookTypeHandler            First       (Perl, C)
#  PerlHookFixupHandler           Middle      (C, Perl)

my $expected = <<EOF;
postreadrequest: C, Perl
trans: Perl, C
maptostorage: Perl, C
headerparser: C, Perl
access: C, Perl
type: Perl, C
fixup: C, Perl
EOF

ok t_cmp($expected,
         $received,
         'mixed ordering');
