#include "httpd.h"
#include "http_config.h"
#include "http_request.h"
#include "http_protocol.h"
#include "http_log.h"
#include "apr_pools.h"

module AP_MODULE_DECLARE_DATA hook_order_module;

typedef struct {
    void (*pFunc)(void); /* just to get the right size */
    const char *szName;
    const char * const *aszPredecessors;
    const char * const *aszSuccessors;
    int nOrder;
} hook_struct_t;

typedef apr_array_header_t * (
#ifdef WIN32
__stdcall
#endif
* hook_get_t)(void);

typedef struct {
    const char *name;
    hook_get_t get;
} hook_lookup_t;

static hook_lookup_t request_hooks[] = {
    {"HookPostReadRequestHandler", ap_hook_get_post_read_request},
    {"HookTransHandler", ap_hook_get_translate_name},
    {"HookMapToStorageHandler", ap_hook_get_map_to_storage},
    {"HookHeaderParserHandler", ap_hook_get_header_parser},
    {"HookAccessHandler", ap_hook_get_access_checker},
    {"HookAuthenHandler", ap_hook_get_check_user_id},
    {"HookAuthzHandler", ap_hook_get_auth_checker},
    {"HookTypeHandler", ap_hook_get_type_checker},
    {"HookFixupHandler", ap_hook_get_fixups},
    {"HookLogHandler", ap_hook_get_log_transaction},
    {NULL},
};

static int reorder_hooks(apr_pool_t *pconf, apr_pool_t *plog,
                         apr_pool_t *ptemp, server_rec *s)
{
    int i, j;

#ifdef WIN32
    if (getenv("AP_PARENT_PID")) {
        /* we need to reorder in the parent process only */
        return OK;
    }
#endif 

   ap_log_error(APLOG_MARK, APLOG_INFO, 0, s,
                "------------- starting --------------");

    for (i = 0; request_hooks[i].name; i++) {
        int order = APR_HOOK_LAST;
        apr_array_header_t *hooks;
        hook_struct_t *elts;

        hooks = request_hooks[i].get();
        elts = (hook_struct_t *)hooks->elts;

        /* isolate mod_perl from the phase hooks and insert new ordering */

        for (j = 0; j < hooks->nelts; j++) {
            ap_log_error(APLOG_MARK, APLOG_INFO, 0, s,
                          "found module %s scheduled for hook %s", 
                           elts[j].szName, request_hooks[i]);

            if (strcmp(elts[j].szName,"mod_perl.c") == 0) {
            ap_log_error(APLOG_MARK, APLOG_INFO, 0, s,
                          "reordering %s in hook %s", 
                           elts[j].szName, request_hooks[i]);

                elts[j].nOrder = order;
            }
        }
    }

    apr_hook_sort_all();

    ap_log_error(APLOG_MARK, APLOG_INFO, 0, s,
                 "------------- ending --------------");

    return OK;
}


static void register_hooks(apr_pool_t *p)
{
    ap_hook_post_config(reorder_hooks, NULL, NULL, APR_HOOK_FIRST);
}

module AP_MODULE_DECLARE_DATA hook_order_module =
{
    STANDARD20_MODULE_STUFF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    register_hooks
};

