use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 2, have_lwp;

{
    my $response = GET '/bug';
    chomp(my $content = $response->content);

    ok t_cmp($content,
             'found a bug',
             'Bug.pm');
}

{
    my $response = GET '/perl-bin/bug.pl';
    chomp(my $content = $response->content);

    ok t_cmp($content,
             'found a bug',
             'bug.pl');
}
