package org.cyrano.qdox.QDoxTestMojo;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;

@Mojo(name = "test", defaultPhase = LifecyclePhase.GENERATE_SOURCES)
public class MyMojo extends AbstractMojo {
  
  // --------------------------------------------------------------------------------

  private static boolean printMethodAnnotations(JavaClass javaClass) {

    List<JavaMethod> methods = javaClass.getMethods();

    for (JavaMethod javaMethod : methods) {
      List<JavaAnnotation> annotationList = javaMethod.getAnnotations();

      for (JavaAnnotation annotation : annotationList) {
        System.err.println(annotation.getType().getValue());
      }
    }

    return false;
  }

  // --------------------------------------------------------------------------------
  
  private static boolean printClassAnnotations(JavaClass javaClass) {
    List<JavaAnnotation> annotationList = javaClass.getAnnotations();

    for (JavaAnnotation annotation : annotationList) {
      System.err.println(annotation.getType().getValue());
    }

    return false;
  }

  // --------------------------------------------------------------------------------
  
  public void execute() throws MojoExecutionException {
    
    JavaProjectBuilder builder = new JavaProjectBuilder();

    builder.addSourceFolder(new File("src/main/java"));

    JavaClass javaClass = builder.getClassByName("org.cyrano.qdox.DemoClass");

    System.err.println("*********************");
    System.err.println("Method Annotations...");
    System.err.println("*********************");
    printMethodAnnotations(javaClass);

    System.err.println("*********************");
    System.err.println("Class Annotations... ");
    System.err.println("*********************");
    printClassAnnotations(javaClass);
  }
}