 
#include <qpid/client/Connection.h>
#include <qpid/client/SubscriptionManager.h>
#include <iostream>

using std::cout;
using std::endl;
using std::string;
using std::exception;

using namespace qpid::client;
using namespace qpid::framing;

int main(int argc, char** argv) 
{
  // Get arguments
  if (argc != 2 + 1)
  {
    cout << "Usage: " << argv[0] << endl
         << "  [broker_ip_addr] " << endl
         << "  [protocol (tcp|rdma)]" << endl
         << endl;
    return 1;
  }
  const string arg_broker_ip_addr(argv[1]);
  const string arg_protcol(argv[2]);

  
  // Declare local variables
  Connection connection;
  ConnectionSettings conn_setngs;
  Message producer_msg;
  LocalQueue local_my_queue;
  Session session, session_ack;
  SubscriptionSettings subscrptn_setngs;
  string my_queue_name;

  //Open the session
  try 
    {
      conn_setngs.host= arg_broker_ip_addr;
      conn_setngs.protocol= arg_protcol;
      connection.open(conn_setngs);
      session =  connection.newSession();
      
      // Declare a queue
      my_queue_name=session.getId().getName();
      session.queueDeclare(arg::queue=my_queue_name, arg::exclusive=true,
                          arg::autoDelete=true);
      session.exchangeBind(arg::exchange="amq.fanout", 
                          arg::queue=my_queue_name,
                          arg::bindingKey="my-key");
                          
      // Set subscription settings
      subscrptn_setngs.flowControl= FlowControl::unlimited();
      subscrptn_setngs.autoAck= 1; 
      // Accept and acquire modes defined in ./src/gen/qpid/framing/enum.h
      subscrptn_setngs.acceptMode= ACCEPT_MODE_EXPLICIT;
      subscrptn_setngs.acquireMode= ACQUIRE_MODE_PRE_ACQUIRED;
      
      // Subscribe to fanout via local queue
      SubscriptionManager subscriptions(session);
      subscriptions.subscribe(local_my_queue, my_queue_name, 
                              subscrptn_setngs, my_queue_name);

      // Get a message
      producer_msg = local_my_queue.get();
      cout << "I GOT THE MESSAGE:  "
           << "msg.getData().size()= " << producer_msg.getData().size() << endl;

      // Shutdown the connection
      subscriptions.cancel(my_queue_name);
      session.queuePurge(my_queue_name);
      session.queueDelete(my_queue_name, false, false);
      connection.close();
  } // end try
  
  // Exception handling
  catch(const exception& error) 
  {
    cout << error.what() << endl;
    connection.close();
    return 1;
  }
  catch(const string err_msg)
  {
    cout << err_msg << endl;
    connection.close();
    return 1;
  }
  catch(...)
  {
    cout << "Unspecified exception" << endl;
    connection.close();
    return 1;
  }
  // Exit main
  return 0;
} // end main
