 
#include <qpid/client/Connection.h>
#include <qpid/client/SubscriptionManager.h>
#include <iostream>

using std::cout;
using std::endl;
using std::string;
using std::exception;

using namespace qpid::client;
using namespace qpid::framing;

int main(int argc, char** argv) 
{
  // Get arguments
  if (argc != 3 + 1)
  {
    cout << "Usage: " << argv[0] << endl
         << "  [broker_ip_addr] " << endl
         << "  [msg_size] " << endl
         << "  [protocol (tcp|rdma)]" << endl
         << endl;
    return 1;
  }
  const string arg_broker_ip_addr(argv[1]);
  const int arg_msg_size= atoi(argv[2]);
  const string arg_protcol(argv[3]);
  
  // Declar local vars
  Connection connection;
  ConnectionSettings conn_setngs;
  Message message;
  Session session;

  try {
    // Open the session
    conn_setngs.host= arg_broker_ip_addr;
    conn_setngs.protocol= arg_protcol;
    connection.open(conn_setngs);
    session = connection.newSession();
    
    // Create a string of size msg size
    string msg_string(arg_msg_size, 'a');
    // Set the msg payload to the string
    message.setData(msg_string);
    // Send the msg
    async(session).messageTransfer(arg::content=message, 
      arg::destination="amq.fanout");
    // Close the connection
    connection.close();
    
  } // end try
  
  // Exception handling
  catch(const exception& error) 
  {
    cout << error.what() << endl;
    connection.close();
    return 1;
  }
  catch(const string err_msg)
  {
    cout << err_msg << endl;
    connection.close();
    return 1;
  }
  catch(...)
  {
    cout << "Unspecified exception" << endl;
    connection.close();
    return 1;
  }
  
  // Exit main
  return 0;
} // end main


