# `$TITLE`

> *A very short description.  This text, in addition to a number that
> is assigned later, will identify the QIP.*

## Status

> *Draft, accepted, rejected, final, deferred, withdrawn, or
> abandoned.  A QIP starts out in draft status.*

> *You may add text to expand on the status, but keep it brief.*

Draft

## Summary

> *A short description of the proposal to orient the reader.*

## Problem

> *Describe the problem that motivates this QIP.  Knowing why this
> improvement is important will help us understand what it is and what
> its priority should be.*

## Solution

> *Tell us about the solution you chose to address the problem.  This
> should include some detail about design decisions.  If the change
> affects user experience, provide example use scenarios.*

## Rationale

> *Explain why you chose this solution and not another.  If it's
> pertinent, list goals and non-goals of the solution.*

## Implementation Notes

> *What steps are required to implement this QIP?  What Qpid
> components are affected?  If there is new code, where will it reside
> in the tree?*

## Consequences

> *Address any possible impact in the following areas:*

> - *__Development:__ Does it affect the way developers work on Qpid?*
> - *__Release:__ Does it require changes to the release
>   infrastructure or process?  For instance, some QIPs may require
>   changes to the build system.*
> - *__Documentation:__ Does it require new documentation or changes
    to existing documentation?*
> - *__Configuration:__ Does it affect the way Qpid is configured and
    deployed?*
> - *__Compatibility:__ Does it break API or ABI compatibility with
>   existing software?*

## Contributor-in-Charge

> *This is the person who holds final responsibility for this QIP.  It
> must be a human being, not a company or other group. To avoid any
> confusion about who is responsible, it must be one and only one
> person.*

> *Please include an email address.*

Some Contributor, <some.contributor@example.org>

## Contributors

> *A list of the people who will help implement this QIP.  Include
> email addresses.*

 - Another Contributor, <another.contributor@example.org>
 - Another Still, <another.still@example.org>

## Version

> *A version number for this document.  Use the format
> `$MAJOR.$MINOR`.  For major changes, increment the former, and for
> minor changes such as typos, increment the latter.*

1.0
