/* 
 * Copyright (c) 2004-2007 QOS.CH
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute, and/or sell copies of  the Software, and to permit persons
 * to whom  the Software is furnished  to do so, provided  that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the  Software and  that both  the above  copyright notice(s)  and this
 * permission notice appear in supporting documentation.
 * 
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR  A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF  THIRD PARTY  RIGHTS. IN  NO EVENT  SHALL THE  COPYRIGHT  HOLDER OR
 * HOLDERS  INCLUDED IN  THIS  NOTICE BE  LIABLE  FOR ANY  CLAIM, OR  ANY
 * SPECIAL INDIRECT  OR CONSEQUENTIAL DAMAGES, OR  ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS  OF USE, DATA OR PROFITS, WHETHER  IN AN ACTION OF
 * CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS  ACTION, ARISING OUT OF  OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * Except as  contained in  this notice, the  name of a  copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

package org.slf4j;

import junit.framework.TestCase;


/**
 * Test whether invoking the SLF4J API causes problems or not.
 * 
 * @author Ceki Gulcu
 *
 */
public class InvocationTest extends TestCase {

  SilentPrintStream ps;
  
  public InvocationTest (String arg0) {
    super(arg0);
  }

  protected void setUp() throws Exception {
    super.setUp();
    
    this.ps = new SilentPrintStream(System.err);

    System.setErr(this.ps);
  }

  protected void tearDown() throws Exception {
    super.tearDown();
    System.setErr(this.ps.getSuperPrintStream());
  }
  
  public void test1() {

    Logger guineaPig1 = LoggerFactory.getLogger("test1");
    Logger guineaPig2 = LoggerFactory.getLogger("test1");

    assertEquals("Expecting reference to same Logger but wasnt!", guineaPig1, guineaPig2);
  }
  
  public void test2() {

    Logger guineaPig1 = LoggerFactory.getLogger("test2_1");
    Logger guineaPig2 = LoggerFactory.getLogger("test2_2");

    assertNotSame("Expecting reference to different Logger but wasnt!", guineaPig1, guineaPig2);
  }
  
  public void testMDC() {
    MDC.put("k", "v");
    assertNull(MDC.get("k"));
    MDC.remove("k");
    assertNull(MDC.get("k"));
    MDC.clear();
  }
}
