package org.slf4j;

import java.io.PrintStream;

public class SilentPrintStream extends PrintStream {

  private static final int DEFAULT_LINE_LENGTH = 255;
	
  private PrintStream other;
  private StringBuffer lineBuffer;
  
  private boolean isRecording;
  private boolean newLine;

  public SilentPrintStream(PrintStream ps) {
    super(ps);

    this.other = ps;
  }

  public void print(String s) {

	  if(!isRecording){
		  return;
	  }

	  if( newLine ){
		  this.lineBuffer = new StringBuffer( DEFAULT_LINE_LENGTH );
		  this.newLine = false;
	  }
	  
	  this.lineBuffer.append(s);
  }

  public void println(String s) {

	  if(!isRecording){
		  return;
	  }
	  
	  if( newLine ) {
		  this.lineBuffer = new StringBuffer( DEFAULT_LINE_LENGTH );
	  }
	  
	  this.lineBuffer.append(s);
  }
  
  public void println(Object x) {
	  if(!isRecording){
		  return;
	  }
	  
	  if( newLine ) {
		  this.lineBuffer = new StringBuffer( DEFAULT_LINE_LENGTH );
		  this.newLine = false;
	  }
	  
	  this.lineBuffer.append(x);
  }

  public void recordingOn(){
	  this.isRecording = true;
	  this.newLine = true;
  }

  public void recordingOff(){
	  this.isRecording = false;
  }

  public String getLastRecordedLine(){
	  return this.lineBuffer == null ? "" : this.lineBuffer.toString();  
  }
  
  public PrintStream getSuperPrintStream(){
	  return other;
  }
}
