/* 
 * Copyright (c) 2004-2007 QOS.CH
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute, and/or sell copies of  the Software, and to permit persons
 * to whom  the Software is furnished  to do so, provided  that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the  Software and  that both  the above  copyright notice(s)  and this
 * permission notice appear in supporting documentation.
 * 
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR  A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF  THIRD PARTY  RIGHTS. IN  NO EVENT  SHALL THE  COPYRIGHT  HOLDER OR
 * HOLDERS  INCLUDED IN  THIS  NOTICE BE  LIABLE  FOR ANY  CLAIM, OR  ANY
 * SPECIAL INDIRECT  OR CONSEQUENTIAL DAMAGES, OR  ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS  OF USE, DATA OR PROFITS, WHETHER  IN AN ACTION OF
 * CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS  ACTION, ARISING OUT OF  OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * Except as  contained in  this notice, the  name of a  copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

package org.slf4j.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Test whether invoking the SLF4J API causes problems or not.
 * 
 * @author Erik Dick
 *
 */
public class SimpleLoggerInfoTest extends SimpleLoggerAbstractTest {

  /**
   * The log level for this testcase.
   * <em>Do not use SimpleLogger.<x>_STR to define the LOG_LEVEL otherwise the
   * testcases will fail due to order of executed static initializers.</em>
   */
	
  private static final String LOG_LEVEL = "INFO";


  public SimpleLoggerInfoTest (String arg0) {
    super(arg0);
  }
  
  protected String initiateLogLevel(){
    System.setProperty(SimpleLogger.LOG_LEVEL_PROPERTY, LOG_LEVEL );
    return LOG_LEVEL;
  }

  public void test0() {

    Logger logger = LoggerFactory.getLogger("test0");

    assertEquals("Failed to detect the correct log level!\n all subsequent tests void!",
                 LOG_LEVEL,
                 SimpleLogger.logLevel);
    
    assertFalse( "Expected trace level to be disabled, but was not", logger.isTraceEnabled() );
    assertFalse( "Expected debug level to be disabled, but was not", logger.isDebugEnabled() );
    assertTrue( "Expected info level to be enabled, but was not", logger.isInfoEnabled() );
    assertTrue( "Expected warn level to be enabled, but was not", logger.isWarnEnabled() );
    assertTrue( "Expected error level to be enabled, but was not", logger.isErrorEnabled() );
  }
}
