#include <svn_client.h>
#include <svn_auth.h>
#include <svn_ra.h>

static svn_error_t* auth_callback (svn_auth_cred_simple_t **cred, void *baton, const char *realm, const char *username, svn_boolean_t may_save, apr_pool_t *pool) {
  svn_auth_cred_simple_t *ret = apr_pcalloc (pool, sizeof (*ret));
  char answerbuf[100];

  if (username)
    ret->username = apr_pstrdup (pool, username);
  else
    {
      ret->username = apr_pstrdup (pool, "username");
    }

  ret->password = apr_pstrdup (pool, "password");

  *cred = ret;
  return SVN_NO_ERROR;
}


svn_error_t* print_status(void *baton, const char *path, const svn_client_status_t *status, apr_pool_t *pool) {
   printf("%s: revision %d\n", path, status->ood_changed_rev);
}


int main(int argc, char **argv) {
   apr_pool_t* pool;

   apr_pool_initialize();

   apr_pool_create_ex(&pool, NULL, NULL, NULL);

   svn_client_ctx_t *ctx;
   svn_client_create_context(&ctx, pool);


   apr_array_header_t *providers = apr_array_make (pool, 4, sizeof (svn_auth_provider_object_t *));

   svn_auth_provider_object_t *provider;
   svn_auth_get_simple_prompt_provider (&provider, auth_callback, NULL, 1, pool);
   APR_ARRAY_PUSH (providers, svn_auth_provider_object_t *) = provider;
   svn_auth_open (&ctx->auth_baton, providers, pool);

   svn_revnum_t rev = 2;
   svn_opt_revision_t revision;
   revision.kind = svn_opt_revision_head;

   svn_client_status5(&rev, ctx, "file", &revision, svn_depth_infinity, FALSE, TRUE, TRUE, FALSE, FALSE, NULL, &print_status, NULL, pool);

   apr_pool_destroy(pool);
   apr_pool_terminate();
   return 0;
}
