#!/bin/sh

set -x

REPOS_URL=https://svn.apache.org/repos/asf/subversion/trunk
BUILD_NAME=subversion-1.14.0

if [ -d subversion ]; then
    echo "***** Removed old Subversion source code *****"
    rm -rf subversion
fi
    
echo "***** Checking out Subversion source code *****"
svn checkout ${REPOS_URL} subversion

echo "***** Fetching the checked-out revision *****"
cd subversion
patch -p0 < /app/1.14.release-line.patch.txt
SVN_REVISION=`svn info --show-item=revision -- ${REPOS_URL}`

echo "***** Preparing build environment *****"
cd tools/dist
./release.py --clean --verbose --branch trunk build-env ${BUILD_NAME}

echo "***** Building ${BUILD_NAME} ${SVN_REVISION} *****"
export SWIG_PY_OPTS="-python -py3 -nofastunpack -modern"
./release.py --verbose --branch trunk roll ${BUILD_NAME} ${SVN_REVISION}

echo "***** Copying build artifacts into target folder *****"
cp deploy/* /app/target
