/* Move the mouse cursor with the keyboard
 * (C)opyright Robert Hickman<robert.e.hickman@googlemail.com>
 *
 * Based on swarp, http://tools.suckless.org/swarp
 * (C)opyright MMIV-MMV Anselm R. Garbe <garbeam at gmail dot com>
 * See LICENSE file for license details.
 */

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>

    typedef struct {
        int x;
        int y;
    } vec2d;

// Functions
    vec2d get_c_loc();
    void set_c_loc(vec2d loc);

// Globals
    Display *dpy = NULL;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Main entry point
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
    int main(int argc, char **argv)
    {
    // Connect to X server
        XtToolkitInitialize();
        dpy = XtOpenDisplay(XtCreateApplicationContext(), NULL,
            "xptr", "xptr", NULL, 0, &argc, argv);

        if(!dpy)
        {
            fputs("cannot open display\n", stderr);
            exit(EXIT_FAILURE);
        }

    // Move the cursor right 4000 pixels
        int i;
        for(i = 0; i < 4000; i ++)
        {
            vec2d loc = get_c_loc();
            loc.x += 1;
            set_c_loc(loc);
        }

        XCloseDisplay(dpy);
        return 0;
    }

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Get the location of the cursor
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
vec2d get_c_loc()
{
    Window junk1;
    int junk3, junk2;
    vec2d loc;

    XQueryPointer(dpy, DefaultRootWindow(dpy), &junk1, &junk1,
        &loc.x, &loc.y, &junk2, &junk2, &junk3);

    return loc;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Set the location of the cursor
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void set_c_loc(vec2d loc)
{
    XWarpPointer(dpy, None, RootWindow(dpy, DefaultScreen(dpy)),
            0, 0, 0, 0, loc.x, loc.y);
    XSetInputFocus(dpy, PointerRoot, RevertToPointerRoot, CurrentTime);
}
