/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

public class SingletonMBeanServerBuilder
extends MBeanServerBuilder {
    private static MBeanServer theMBeanServer;
    private static MBeanServerDelegate theMBeanServerDelegate;
    private static final CountDownLatch mbeanServerInited;
    private static final CountDownLatch mbeanServerDelegateInited;

    static {
        mbeanServerInited = new CountDownLatch(1);
        mbeanServerDelegateInited = new CountDownLatch(1);
    }

    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        return this.checkAndInitMBeanServer(defaultDomain, outer, delegate);
    }

    public MBeanServerDelegate newMBeanServerDelegate() {
        return this.checkAndInitMBeanServerDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServer checkAndInitMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        CountDownLatch countDownLatch = mbeanServerInited;
        synchronized (countDownLatch) {
            if (mbeanServerInited.getCount() != 0L) {
                theMBeanServer = super.newMBeanServer(defaultDomain, outer, delegate);
                mbeanServerInited.countDown();
            }
        }
        return theMBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerDelegate checkAndInitMBeanServerDelegate() {
        CountDownLatch countDownLatch = mbeanServerDelegateInited;
        synchronized (countDownLatch) {
            if (mbeanServerDelegateInited.getCount() != 0L) {
                theMBeanServerDelegate = super.newMBeanServerDelegate();
                mbeanServerDelegateInited.countDown();
            }
        }
        return theMBeanServerDelegate;
    }
}

