package ws.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class Client {

	public static void main(String[] args) {
		
		WebSocketContainer wsContainer =  ContainerProvider.getWebSocketContainer();
		ClientEndPoint clientEndPoint = new ClientEndPoint();
		Session session = null;
		try {
			session = wsContainer.connectToServer(clientEndPoint, new URI("ws://localhost:8080/ws/ping"));
		} catch (DeploymentException | IOException | URISyntaxException e) {
			e.printStackTrace();
		}
		
		if (session == null){
			System.out.println("WebSocket session is null");
			return;
		}
		
		System.out.println(String.format("session with id %s is open",session.getId()));
		
		try {
			ByteBuffer applicationData = ByteBuffer.wrap(new String("client").getBytes());
			session.getBasicRemote().sendPing(applicationData);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		try {
			Thread.currentThread();
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
		

	}

}
