package cz.quickstart;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HomePage extends WebPage {
	private static final long serialVersionUID = 1L;
	private Form<Void> formOuter;
	private Form<Void> formInner;

	public HomePage(final PageParameters parameters) {
		super(parameters);

		formOuter = new Form<Void>("outer");
		formInner = new Form<Void>("inner") {
			@Override
			protected boolean wantSubmitOnParentFormSubmit() {
				return false;
			}

			@Override
			protected void onSubmit() {
				super.onSubmit();
				System.out.println("HomePage.HomePage(...).new Form() {...}.onSubmit()");
			}
		};
		add(formOuter);
		formOuter.add(formInner);
		formInner.add(new AjaxButton("submit", formInner) {
			@Override
			protected void onSubmit(AjaxRequestTarget target) {
				super.onSubmit(target);
				System.out.println("HomePage.HomePage(...).new AjaxButton() {...}.onSubmit()");
			}
		});
		formInner.add(new SubmitLink("submit-link", formInner) {
			@Override
			public void onAfterSubmit() {
				// TODO Auto-generated method stub
				super.onAfterSubmit();
				System.out.println("HomePage.HomePage(...).new SubmitLink() {...}.onAfterSubmit()");
			}
		});

	}
}
