package com.voipfuture;

import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ExpiredPage extends WebPage
{

    protected static abstract class AjaxButton extends Button
    {
        public AjaxButton(String wicketId)
        {
            super(wicketId);
            add(new AjaxEventBehavior("click") {

                @Override
                protected void onEvent(final AjaxRequestTarget target) {
                    onClick( target );
                }
            });
        }

        public abstract void onClick(AjaxRequestTarget target);
    }

    public ExpiredPage()
    {
        final AjaxButton button = new AjaxButton( "resumeButton" )
        {
            @Override
            public void onClick(AjaxRequestTarget target)
            {
                final PageParameters p = new PageParameters();
                setResponsePage( new HomePage( p ) );
            }
        };
        button.setDefaultFormProcessing( false );
        add( button );
    }
}
