/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.com.xmlbeans;

import org.apache.xmlbeans.Filer;

import java.io.*;

/**
 * Author: amila
 * Date: Dec 21, 2006
 */
public class TestFiler implements Filer {
    public OutputStream createBinaryFile(String typeName) throws IOException {
        System.out.println("creating binary file");

        String resourceDirectory = "../generated/resource";
        File file = new File(resourceDirectory,typeName);
        file.getParentFile().mkdirs();
        file.createNewFile();

        return new FileOutputStream(file);
    }

    public Writer createSourceFile(String typeName) throws IOException {
        System.out.println("creating source file");
        typeName = typeName.replace(".",String.valueOf(File.separatorChar));

        String sourceDirectory = "../generated/src";
        File file = new File(sourceDirectory,typeName + ".java");
        file.getParentFile().mkdirs();
        file.createNewFile();
        return new FileWriter(file);
    }
}
